<?php
session_start();
include '../../includes/db_connection.php';

// Header code (from header.php)
if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>School Management System</title>
    <link rel="stylesheet" href="/school_management/public/css/style.css">
</head>
<body>
<div class="header">
    <h1>School Management System</h1>
    <div class="nav">
        <a href="/school_management/public/dashboard.php">Dashboard</a>
        <a href="/school_management/public/students/students_list.php">Students</a>
        <a href="/school_management/public/teachers/teachers_list.php">Teachers</a>
        <a href="/school_management/public/fees/fee_collection.php">Fees</a>
        <a href="/school_management/public/exam_results/add_exam_result.php">Exams</a>
        <a href="/school_management/public/attendance/record_attendance.php">Attendance</a>
        <a href="/school_management/public/change_password.php">Change Password</a>
        <a href="/school_management/public/logout.php">Logout</a>
    </div>
</div>
<div class="content">

<?php
if ($_SESSION['role'] !== 'Admin') {
    echo "<p style='color:red;'>You do not have permission to view this page.</p>";
    echo "</div></body></html>";
    exit();
}

$sql = "SELECT 
            teachers.teacher_id, 
            teachers.first_name, 
            teachers.last_name, 
            teachers.email, 
            teachers.phone_number,
            teachers.subject,
            teachers.joining_date,
            classes.class_name
        FROM 
            teachers
        LEFT JOIN 
            classes ON teachers.class_id = classes.class_id";

$result = $conn->query($sql);
?>

<div class="container">
    <h2>Teachers List</h2>
    <p><a href="add_teacher.php">Add New Teacher</a></p>
    <?php
    if ($result->num_rows > 0) {
        echo "<table>";
        echo "<tr>
                <th>ID</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Subject</th>
                <th>Joining Date</th>
                <th>Class</th>
                <th>Actions</th>
              </tr>";
        while($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($row['teacher_id']) . "</td>";
            echo "<td>" . htmlspecialchars($row['first_name'] . " " . $row['last_name']) . "</td>";
            echo "<td>" . htmlspecialchars($row['email']) . "</td>";
            echo "<td>" . htmlspecialchars($row['phone_number']) . "</td>";
            echo "<td>" . htmlspecialchars($row['subject']) . "</td>";
            echo "<td>" . htmlspecialchars($row['joining_date']) . "</td>";
            echo "<td>" . htmlspecialchars($row['class_name'] ?? 'N/A') . "</td>";
            echo "<td>
                    <a href='edit_teacher.php?id=" . htmlspecialchars($row['teacher_id']) . "'>Edit</a> | 
                    <a href='delete_teacher.php?id=" . htmlspecialchars($row['teacher_id']) . "' onclick='return confirm(\"Are you sure you want to delete this teacher?\");'>Delete</a>
                  </td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "No teachers found.";
    }
    ?>
</div>

<?php
$conn->close();
?>

<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> School Management System. All Rights Reserved.</p>
</div>
</div>
</body>
</html>