<?php
session_start();
// নিশ্চিত করুন যে এই পাথটি আপনার ডেটাবেস সংযোগ ফাইলের সঠিক ঠিকানা
include '../../includes/db_connection.php'; 

if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}

// ==========================================
// ১. শিক্ষার্থী মুছে ফেলার (Deletion) লজিক (অপরিবর্তিত)
// ==========================================
$message = '';
$error = '';
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['delete_student_id'])) {
    if (!$conn) {
        $error = "ডাটাবেস সংযোগে সমস্যা।";
    } elseif (isset($_SESSION['role']) && $_SESSION['role'] === 'Admin') {
        $student_id = intval($_POST['delete_student_id']); 
        
        $sql = "DELETE FROM students WHERE student_id = ?";
        $stmt_del = $conn->prepare($sql);
        
        if ($stmt_del === false) {
             $error = "প্রস্তুতি ব্যর্থ হয়েছে: " . $conn->error;
        } else {
            // ছবির লজিক এখানে যুক্ত করা যেতে পারে
            $stmt_del->bind_param("i", $student_id);
            if ($stmt_del->execute()) {
                $message = "শিক্ষার্থী সফলভাবে মুছে ফেলা হয়েছে!";
            } else {
                $error = "শিক্ষার্থী মোছার সময় সমস্যা হয়েছে: " . $stmt_del->error;
            }
            $stmt_del->close();
        }
    } else {
        $error = "মুছে ফেলার অনুমতি নেই।";
    }
}

// ==========================================
// ২. সার্চ ও ফিল্টারের জন্য অতিরিক্ত ডাটাবেস কোয়েরি (চূড়ান্ত এবং নির্ভুল)
// ==========================================

// সকল শ্রেণি (Classes) আনা হচ্ছে ফিল্টার ড্রপডাউনের জন্য
$classes_sql = "SELECT class_id, class_name FROM classes ORDER BY class_id";
$classes_result = $conn ? $conn->query($classes_sql) : null; 

// সার্চ প্যারামিটার নির্ধারণ
$search_query = isset($_GET['search']) ? trim($_GET['search']) : '';
$selected_class_id = isset($_GET['class_id']) ? intval($_GET['class_id']) : 0;

// WHERE ক্লজ তৈরি করা
$where_clauses = [];
$bind_params = '';
$bind_values = [];

// *** চূড়ান্ত সার্চ লজিক: সংখ্যা ও স্ট্রিংকে আলাদা করে দেওয়া হলো ***
$is_numeric_search = is_numeric($search_query);

if (!empty($search_query)) {
    
    if ($is_numeric_search) {
        // যদি ইনপুট সংখ্যা হয় (ID/Roll)
        $numeric_value = intval($search_query);
        $search_term = "%" . $search_query . "%"; // জন্ম নিবন্ধন/ফোন নম্বর LIKE এর জন্য
        
        // এখানে নাম খোঁজা হবে না, শুধুমাত্র আইডি, রোল, জন্ম নিবন্ধন এবং ফোন নম্বর দিয়ে খোঁজা হবে।
        $where_clauses[] = " (s.student_id = ? OR s.class_roll = ? OR s.birth_reg_no LIKE ? OR s.phone_number LIKE ?) ";
        $bind_params .= "iiss"; 
        $bind_values[] = $numeric_value;    // 1. student_id (হুবহু ম্যাচ)
        $bind_values[] = $numeric_value;    // 2. class_roll (হুবহু ম্যাচ)
        $bind_values[] = $search_term;      // 3. birth_reg_no (LIKE)
        $bind_values[] = $search_term;      // 4. phone_number (LIKE)
        
    } else {
        // যদি ইনপুট স্ট্রিং হয় (নাম)
        $search_term = "%" . $search_query . "%";
        
        // এখানে শুধুমাত্র নাম দিয়ে খোঁজা হবে
        $where_clauses[] = " (s.first_name LIKE ? OR s.last_name LIKE ?) ";
        $bind_params .= "ss"; 
        $bind_values[] = $search_term;  // 1. first_name (LIKE)
        $bind_values[] = $search_term;  // 2. last_name (LIKE)
    }
}
// *** চূড়ান্ত সংশোধিত সার্চ লজিক শেষ ***

// ক্লাস ড্রপডাউন ফিল্টারিং
if ($selected_class_id > 0) {
    $where_clauses[] = " s.class_id = ? ";
    $bind_params .= "i";
    $bind_values[] = $selected_class_id;
}

// WHERE ক্লজ একত্রিত করা
$where_sql = '';
if (!empty($where_clauses)) {
    $where_sql = " WHERE " . implode(" AND ", $where_clauses);
}

// মূল SQL কোয়েরি
$sql = "SELECT 
            s.student_id, 
            s.first_name, 
            s.last_name, 
            s.father_name, 
            s.mother_name, 
            s.birth_reg_no, 
            s.village, 
            s.upazila, 
            s.district, 
            s.previous_institute, 
            c.class_name, 
            s.class_roll, 
            s.fixed_fee, 
            s.date_of_birth, 
            s.enrollment_date,
            s.class_id
        FROM students s
        JOIN classes c ON s.class_id = c.class_id
        " . $where_sql . "
        ORDER BY c.class_name, s.class_roll";

// Prepared statement তৈরি ও সম্পাদন করা
$result = null; 
$stmt_main = null; 

if ($conn) {
    if (empty($bind_values)) {
        // কোনো ফিল্টার না থাকলে সরাসরি কোয়েরি চালানো
        $result = $conn->query($sql);
    } else {
        // ফিল্টার থাকলে Prepared Statement ব্যবহার করা
        $stmt_main = $conn->prepare($sql);
        
        if ($stmt_main === false) {
            $error = "ডাটা কোয়েরি প্রস্তুতি ব্যর্থ: " . $conn->error;
            $result = (object) ['num_rows' => 0]; // ডামি ফলাফল
        } else {
            // bind_param ডায়নামিকভাবে কল করা
            $stmt_main->bind_param($bind_params, ...$bind_values); 
            $stmt_main->execute();
            $result = $stmt_main->get_result();
        }
    }
} else {
    $error = "ডাটাবেস সংযোগ স্থাপন করা যায়নি।";
}


// ==========================================
// ৩. সংযোগ বন্ধ করার চূড়ান্ত লজিক (সংশোধিত)
// ==========================================
// সমস্ত স্টেটমেন্ট এবং সংযোগ বন্ধ করা
if (isset($stmt_main) && $stmt_main instanceof mysqli_stmt) {
    $stmt_main->close();
}
if (isset($stmt_del) && $stmt_del instanceof mysqli_stmt) {
    $stmt_del->close();
}
// mysqli_stmt এর বন্ধ করার পরে $conn বন্ধ করা হলো
if (isset($conn) && $conn->ping()) {
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>শিক্ষার্থী তালিকা</title>
    <link rel="stylesheet" href="/school_management/public/css/style.css"> 
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <style>
        /* CSS স্টাইল */
        .list-container {
            margin-top: 20px;
            overflow-x: auto; 
        }
        .list-container table {
            width: 100%;
            min-width: 2200px; 
            border-collapse: collapse;
            margin-top: 20px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        }
        .list-container th, .list-container td {
            border: 1px solid #e1e4e8; 
            padding: 8px 6px; 
            text-align: left;
            font-size: 11px; 
            white-space: nowrap; 
        }
        .list-container th {
            background-color: #34495e; 
            color: white;
            text-align: center;
            font-weight: bold;
        }
        .list-container tr:nth-child(even) {
            background-color: #f8f8f8; 
        }
        .list-container tr:hover {
            background-color: #f0f8ff; 
        }
        .list-container .actions {
            white-space: nowrap; 
            width: 1%; 
            text-align: center;
        }
        .list-container .actions a, .list-container .actions button {
            text-decoration: none;
            padding: 3px 5px; 
            border-radius: 3px;
            margin: 1px; 
            font-size: 10px; 
            display: inline-block;
            line-height: 1.2;
        }
        .list-container .actions .details-btn { 
             background-color: #3b5998; 
             color: white; 
             border: none; 
        }
        .list-container .actions .edit-btn { background-color: #007bff; color: white; border: none; }
        .list-container .actions .delete-btn { background-color: #dc3545; color: white; border: none; cursor: pointer; }
        .list-container .actions .testimonial-btn { background-color: #27ae60; color: white; border: none; } 
        .list-container .actions .admit-btn { background-color: #9b59b6; color: white; border: none; } 
        .list-container .actions .certificate-btn { background-color: #3498db; color: white; border: none; } 
        
        /* সার্চ বার স্টাইল (অপরিবর্তিত) */
        .search-form-container {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
            align-items: center;
            flex-wrap: wrap; 
        }
        .search-form-container input[type="text"],
        .search-form-container select,
        .search-form-container button,
        .search-form-container a.button {
            padding: 8px 12px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
        }
        .search-form-container button {
            background-color: #3498db;
            color: white;
            cursor: pointer;
            border: none;
        }
        .search-form-container button:hover {
            background-color: #2980b9;
        }
        .action-buttons-group {
            display: flex;
            gap: 10px;
            align-items: center;
            flex-wrap: wrap;
        }

        /* প্রিন্ট স্টাইল (অপরিবর্তিত) */
        @media print {
            .header, .nav, .footer, .action-buttons-group, .actions, .search-form-container, .container > h2, .container > p, .modal { display: none !important; }
            .container { width: 100%; max-width: none !important; margin: 0; padding: 5mm; border: none !important; }
            .list-container { overflow: hidden !important; }
            .list-container table { width: 100%; min-width: 100%; }
            .list-container td, .list-container th { font-size: 9px; padding: 3px 2px; border: 1px solid #000; }
            .list-container th { background-color: #e8e8e8 !important; color: #000 !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
            .list-container tr:nth-child(even) { background-color: #f7f7f7 !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
            .school-header-print { display: block !important; margin-bottom: 10px !important; width: 100%; text-align: center; }
            @page { size: legal landscape; margin: 0.5cm; }
        }
        .school-header-print {
            text-align: center; 
            margin-bottom: 20px;
            display: none; 
        }

        /* নতুন CSS: শিক্ষার্থীর নামকে ক্লিকযোগ্য এবং মোডাল স্টাইল */
        .student-name-link {
            color: #2980b9; /* নীল রং */
            cursor: pointer;
            text-decoration: none;
            font-weight: bold;
        }
        .student-name-link:hover {
            text-decoration: underline;
        }

        /* মোডাল (পপআপ) স্টাইল */
        .modal {
            display: none; 
            position: fixed; 
            z-index: 1000; 
            left: 0;
            top: 0;
            width: 100%; 
            height: 100%; 
            overflow: auto; 
            background-color: rgba(0,0,0,0.4); 
        }

        .modal-content {
            background-color: #fefefe;
            margin: 10% auto; /* স্ক্রিনের মাঝখানে আনতে */
            padding: 20px;
            border: 1px solid #888;
            width: 80%; /* পপআপের প্রশস্ততা */
            max-width: 800px;
            border-radius: 8px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.3);
            position: relative;
        }

        .close-btn {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close-btn:hover,
        .close-btn:focus {
            color: #000;
            text-decoration: none;
            cursor: pointer;
        }
        
        .fee-details-table th, .fee-details-table td {
            font-size: 13px;
            padding: 5px;
            text-align: left;
            border: 1px solid #ddd;
        }
        .fee-details-table th {
            background-color: #f2f2f2;
            text-align: center;
        }
    </style>
</head>
<body>
<div class="header">
    <div class="nav">
        <a href="/school_management/public/dashboard.php">ড্যাশবোর্ড</a>
    </div>
    <h1>স্কুল ম্যানেজমেন্ট সিস্টেম</h1>
</div>
<div class="content">
    <div class="container">
        <div class="school-header-print">
            <h2 style="margin-bottom: 5px; color: #2c3e50;">মিফতাহুন নাজাত মহিলা মাদরাসা</h2>
            <p style="margin: 0; font-size: 1.1em; color: #7f8c8d;">নেয়ামতপুর,সদর,নোয়াখালী।</p>
            <p style="font-weight: bold; margin-top: 10px; border-top: 1px solid #ccc; padding-top: 5px;">শিক্ষার্থী তালিকা</p>
        </div>
        
        <h2>শিক্ষার্থী তালিকা</h2>
        
        <?php if ($message): ?>
            <p style='color:green; background-color: #d4edda; padding: 10px; border-radius: 4px;'><?php echo htmlspecialchars($message); ?></p>
        <?php endif; ?>
        <?php if ($error): ?>
            <p style='color:red; background-color: #f8d7da; padding: 10px; border-radius: 4px;'><?php echo htmlspecialchars($error); ?></p>
        <?php endif; ?>

        <form method="GET" action="" class="search-form-container">
            <input 
                type="text" 
                name="search" 
                placeholder="নাম, আইডি, রোল, নিবন্ধন নং দিয়ে খুঁজুন..." 
                value="<?php echo htmlspecialchars($search_query); ?>"
                style="flex-grow: 1; min-width: 250px;"
            >
            <select name="class_id" style="min-width: 150px;">
                <option value="0">-- সব শ্রেণি --</option>
                <?php 
                if ($classes_result && $classes_result->num_rows > 0):
                    $classes_result->data_seek(0);
                    while($class_row = $classes_result->fetch_assoc()): ?>
                        <option 
                            value="<?php echo htmlspecialchars($class_row['class_id']); ?>"
                            <?php echo ($selected_class_id == $class_row['class_id']) ? 'selected' : ''; ?>
                        >
                            <?php echo htmlspecialchars($class_row['class_name']); ?>
                        </option>
                    <?php endwhile;
                endif; 
                ?>
            </select>
            <button type="submit">খুঁজুন <i class="fas fa-search"></i></button>
            <?php if (!empty($search_query) || $selected_class_id > 0): ?>
                <a href="students_list.php" class="button" style="background-color: #f39c12; color: white; text-decoration: none;">ফিল্টার মুছুন <i class="fas fa-times"></i></a>
            <?php endif; ?>
        </form>
        
        <div class="action-buttons-group" style="margin-bottom: 15px;">
            <a href="add_student.php" class="button" style="background-color: #28a745; color: white; text-decoration: none;">+ নতুন শিক্ষার্থী যুক্ত করুন</a>
            <button onclick="window.print()" class="button" style="background-color: #007bff; color: white; margin-left: 10px;">প্রিন্ট করুন (Legal Landscape) 🖨️</button>
        </div>
        
        <div class="list-container">
            <table>
                <thead>
                    <tr>
                        <th>আইডি</th>
                        <th>শিক্ষার্থীর নাম</th>
                        <th>পিতার নাম</th>
                        <th>মাতার নাম</th>
                        <th>জন্ম নিবন্ধন নং</th>
                        <th>গ্রাম</th>
                        <th>উপজেলা</th>
                        <th>জেলা</th>
                        <th>পূর্ববর্তী প্রতিষ্ঠান</th> 
                        <th>শ্রেণি</th>
                        <th>রোল</th>
                        <th>ধার্যকৃত বেতন (৳)</th>
                        <th>জন্ম তারিখ</th>
                        <th>ভর্তির তারিখ</th>
                        <th class="actions">অ্যাকশন</th> 
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    if (isset($result) && $result->num_rows > 0): ?>
                        <?php while($row = $result->fetch_assoc()): 
                            // $current_class_id Admit Card এর জন্য
                            $current_class_id = isset($row['class_id']) ? $row['class_id'] : 0; 
                        ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['student_id']); ?></td>
                                <td>
                                    <a href="#" 
                                       class="student-name-link" 
                                       data-student-id="<?php echo htmlspecialchars($row['student_id']); ?>"
                                       data-student-name="<?php echo htmlspecialchars($row['first_name'] . ' ' . $row['last_name']); ?>"
                                       title="ফি-এর তথ্য দেখতে ক্লিক করুন">
                                        <?php echo htmlspecialchars($row['first_name'] . ' ' . $row['last_name']); ?>
                                    </a>
                                </td>
                                
                                <td><?php echo htmlspecialchars($row['father_name']); ?></td>
                                <td><?php echo htmlspecialchars($row['mother_name']); ?></td>
                                <td><?php echo htmlspecialchars($row['birth_reg_no']); ?></td>
                                <td><?php echo htmlspecialchars($row['village']); ?></td>
                                <td><?php echo htmlspecialchars($row['upazila']); ?></td>
                                <td><?php echo htmlspecialchars($row['district']); ?></td>
                                <td><?php echo htmlspecialchars($row['previous_institute'] ?? 'নেই'); ?></td> 
                                <td><strong><?php echo htmlspecialchars($row['class_name']); ?></strong></td>
                                <td><?php echo htmlspecialchars($row['class_roll']); ?></td>
                                <td><?php echo htmlspecialchars(number_format($row['fixed_fee'], 0)); ?></td>
                                
                                <td>
                                    <?php
                                    $dob = $row['date_of_birth'];
                                    if ($dob && $dob !== '0000-00-00') {
                                        echo date('d-m-Y', strtotime($dob));
                                    } else {
                                        echo 'অজানা';
                                    }
                                    ?>
                                </td>
                                <td><?php echo date('d-m-Y', strtotime($row['enrollment_date'])); ?></td>
                                
                                <td class="actions">
                                    
                                    <a href="view_student_details.php?id=<?php echo htmlspecialchars($row['student_id']); ?>" 
                                        class="details-btn" title="ভর্তি ফরমের মতো বিস্তারিত তথ্য দেখুন">
                                        বিস্তারিত
                                    </a>
                                    
                                    <a href="edit_student.php?id=<?php echo htmlspecialchars($row['student_id']); ?>" class="edit-btn" title="সম্পাদনা">সম্পা.</a>
                                    
                                    <a href="generate_testimonial.php?student_id=<?php echo htmlspecialchars($row['student_id']); ?>" 
                                        class="testimonial-btn" title="প্রত্যয়নপত্র">
                                        প্রত্য.
                                    </a>

                                    <a href="../examinations/generate_admit_card.php?student_id=<?php echo htmlspecialchars($row['student_id']); ?>&class_id=<?php echo $current_class_id; ?>" 
                                         class="admit-btn" title="প্রবেশপত্র">
                                         প্রবে.
                                    </a>

                                    <a href="generate_certificate.php?student_id=<?php echo htmlspecialchars($row['student_id']); ?>" 
                                        class="certificate-btn" title="সার্টিফিকেট">
                                        সার্টি.
                                    </a>

                                    <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'Admin'): ?>
                                        <form method="POST" action="" style="display:inline-block;">
                                            <input type="hidden" name="delete_student_id" value="<?php echo htmlspecialchars($row['student_id']); ?>">
                                            <button type="submit" class="delete-btn" onclick="return confirm('আপনি কি নিশ্চিত যে এই শিক্ষার্থীকে মুছে ফেলতে চান?')">মুছুন</button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="15" style="text-align: center;">কোনো শিক্ষার্থী পাওয়া যায়নি। <?php echo (!empty($search_query) || $selected_class_id > 0) ? 'আপনার খোঁজা ফলাফলের সাথে কোনো মিল পাওয়া যায়নি।' : ''; ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div id="feeModal" class="modal">
    <div class="modal-content">
        <span class="close-btn">&times;</span>
        <h3 id="modalTitle"></h3>
        <div id="feeDetailsContent">
            <p>তথ্য লোড হচ্ছে...</p>
        </div>
    </div>
</div>

<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
</div>
<script>
$(document).ready(function() {
    // ধরে নিচ্ছি মোডাল আইডি 'feeModal' এবং কন্টেন্ট আইডি 'feeDetailsContent'
    var modal = $('#feeModal');
    var span = $('.close-btn'); // মোডালের ক্লোজ বাটন

    // শিক্ষার্থীর নামের লিঙ্কে ক্লিক হ্যান্ডলার
    $('.student-name-link').on('click', function(e) {
        e.preventDefault(); 
        
        var studentId = $(this).data('student-id');
        var studentName = $(this).data('student-name');
        
        // মোডাল টাইটেল সেট করা
        $('#modalTitle').html('শিক্ষার্থী: ' + studentName + ' (' + studentId + ') এর ফি-এর বিবরণ');
        
        // লোডিং মেসেজ সহ মোডাল দেখানো
        $('#feeDetailsContent').html(`
            <p style="text-align:center;">
                <i class="fas fa-spinner fa-spin"></i> তথ্য লোড হচ্ছে, অনুগ্রহ করে অপেক্ষা করুন...
            </p>
        `);
        modal.show();

        // AJAX অনুরোধ: ডেটাবেস থেকে তথ্য আনা (মোডাল মোড)
        $.ajax({
            url: '../fees/fetch_fee_details.php', 
            type: 'GET',
            data: { student_id: studentId, print_mode: 'modal' }, // 'modal' মোড পাঠানো হলো
            success: function(response) {
                // সফলভাবে ডেটা পেলে মোডালে দেখানো
                $('#feeDetailsContent').html(response);
                
                // ** প্রিন্ট বাটন লজিক সেট করা **
                // AJAX কল সফল হওয়ার পর প্রিন্ট বাটন হ্যান্ডলার সেট করতে হবে
                $('#printFeeBtn').off('click').on('click', function() {
                    // নতুন উইন্ডোতে প্রিন্ট-উপযোগী মোডে লোড করার জন্য URL তৈরি
                    var printUrl = '../fees/fetch_fee_details.php?student_id=' + studentId + '&print_mode=yes';
                    
                    var printWindow = window.open(printUrl, '_blank');
                    
                    // উইন্ডো লোড হওয়ার পর প্রিন্ট ডায়ালগ ট্রিগার করা
                    if (printWindow) {
                        printWindow.onload = function() {
                            // প্রিন্ট ডায়ালগ আসার পর উইন্ডো বন্ধ করা
                            printWindow.print();
                        };
                    }
                });
            },
            error: function() {
                // ব্যর্থ হলে ত্রুটির বার্তা দেখানো
                $('#feeDetailsContent').html('<p style="color:red; text-align:center;">ফি-এর তথ্য লোড করতে ব্যর্থ।</p>');
            }
        });
    });

    // ক্রস বাটন ক্লিক করলে মোডাল বন্ধ করা
    span.on('click', function() {
        modal.hide();
    });

    // মোডালের বাইরে ক্লিক করলে মোডাল বন্ধ করা
    $(window).on('click', function(event) {
        if ($(event.target).is(modal)) {
            modal.hide();
        }
    });
});
</script>
</body>
</html>