<?php
session_start();
include '../../includes/db_connection.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}

// Check if student ID is provided in the URL
if (!isset($_GET['id'])) {
    die("No student ID provided.");
}

$student_id = $_GET['id'];
$message = '';
$error = '';

// Handle form submission for updating student details
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $first_name = $_POST['first_name'];
    $last_name = $_POST['last_name'];
    $father_name = $_POST['father_name'];
    $class_roll = $_POST['class_roll'];
    $date_of_birth = $_POST['date_of_birth'];
    $gender = $_POST['gender'];
    $phone_number = $_POST['phone_number'];
    $address = $_POST['address'];
    $class_id = $_POST['class_id'];
    $fixed_fee = $_POST['fixed_fee'];

    $sql = "UPDATE students SET first_name=?, last_name=?, father_name=?, class_roll=?, date_of_birth=?, gender=?, phone_number=?, address=?, class_id=?, fixed_fee=? WHERE student_id=?";
    $stmt = $conn->prepare($sql);
    
    if ($stmt === false) {
        $error = "SQL কোয়েরিতে সমস্যা: " . $conn->error;
    } else {
        $stmt->bind_param("sssisssisdi", $first_name, $last_name, $father_name, $class_roll, $date_of_birth, $gender, $phone_number, $address, $class_id, $fixed_fee, $student_id);

        if ($stmt->execute()) {
            $message = "শিক্ষার্থীর তথ্য সফলভাবে আপডেট করা হয়েছে!";
        } else {
            $error = "তথ্য আপডেটের সময় সমস্যা হয়েছে: " . $stmt->error;
        }
        $stmt->close();
    }
}

// Fetch existing student data to populate the form
$sql_select = "SELECT * FROM students WHERE student_id = ?";
$stmt_select = $conn->prepare($sql_select);
$stmt_select->bind_param("i", $student_id);
$stmt_select->execute();
$student = $stmt_select->get_result()->fetch_assoc();
$stmt_select->close();

if (!$student) {
    die("Student not found.");
}

// Fetch all classes for the dropdown
$classes_sql = "SELECT class_id, class_name FROM classes ORDER BY class_name";
$classes_result = $conn->query($classes_sql);
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>শিক্ষার্থী সম্পাদনা</title>
    <link rel="stylesheet" href="/school_management/public/css/style.css">
    <style>
        /* A4 Page and Form Styling */
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 20px;
        }
        .container {
            width: 210mm;
            min-height: 297mm;
            background-color: white;
            padding: 30px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            margin: 20px auto;
        }
        .admission-form-header {
            text-align: center;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
        .admission-form-header h1, .admission-form-header h2 {
            font-size: 24px;
            margin: 5px 0;
        }
        .admission-form-header p {
            font-size: 14px;
            margin: 0;
            color: #555;
        }
        .form-section {
            margin-bottom: 25px;
            padding: 15px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        .form-section h3 {
            margin-top: 0;
            color: #004d40;
            border-bottom: 1px solid #004d40;
            padding-bottom: 5px;
        }
        .form-group {
            margin-bottom: 15px;
            display: flex;
            align-items: center;
        }
        .form-group label {
            width: 150px;
            flex-shrink: 0;
            font-weight: bold;
            color: #444;
        }
        .form-group input[type="text"],
        .form-group input[type="number"],
        .form-group input[type="date"],
        .form-group select,
        .form-group textarea {
            flex-grow: 1;
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
        }
        .form-group textarea {
            height: 60px;
        }
        .form-group .radio-group {
            display: flex;
            gap: 20px;
        }
        .form-buttons {
            text-align: center;
            margin-top: 30px;
        }
        .form-buttons button, .form-buttons a {
            padding: 12px 25px;
            font-size: 16px;
            cursor: pointer;
            border: none;
            border-radius: 5px;
            color: white;
            background-color: #007bff;
            transition: background-color 0.3s;
            text-decoration: none;
            display: inline-block;
            margin: 0 5px;
        }
        .form-buttons button:hover, .form-buttons a:hover {
            background-color: #0056b3;
        }
        .message-success {
            color: green;
            text-align: center;
            font-weight: bold;
        }
        .message-error {
            color: red;
            text-align: center;
            font-weight: bold;
        }
        
        /* Print Styles */
        @media print {
            body {
                background-color: white;
                margin: 0;
                padding: 0;
            }
            .header, .nav, .footer, .form-buttons {
                display: none;
            }
            .container {
                width: 210mm;
                min-height: 297mm;
                box-shadow: none;
                margin: 0;
                padding: 15mm;
            }
            .form-group input, .form-group select, .form-group textarea {
                border: none;
                border-bottom: 1px dotted #000;
                border-radius: 0;
            }
        }
    </style>
</head>
<body>
<div class="header">
    <h1>স্কুল ম্যানেজমেন্ট সিস্টেম</h1>
    <div class="nav">
        <a href="/school_management/public/dashboard.php">ড্যাশবোর্ড</a>
        <a href="/school_management/public/students/students_list.php">শিক্ষার্থী</a>
        <a href="/school_management/public/teachers/teachers_list.php">শিক্ষক</a>
        <a href="/school_management/public/fees/fee_collection.php">ফি সংগ্রহ</a>
        <a href="/school_management/public/subjects/subjects_list.php">বিষয়সমূহ</a>
        <a href="/school_management/public/exam_results/add_exam_result.php">পরীক্ষা</a>
        <a href="/school_management/public/attendance/record_attendance.php">উপস্থিতি</a>
        <a href="/school_management/public/change_password.php">পাসওয়ার্ড পরিবর্তন</a>
        <a href="/school_management/public/logout.php">লগআউট</a>
    </div>
</div>
<div class="content">

<?php
if ($_SESSION['role'] !== 'Admin') {
    echo "<p style='color:red;'>আপনার এই পেজ দেখার অনুমতি নেই।</p>";
    echo "</div></body></html>";
    exit();
}
?>

<div class="container">
    <div class="admission-form-header">
        <h1>শিক্ষার্থী তথ্য সম্পাদনা</h1>
        <p>বর্তমান শিক্ষার্থীর তথ্য আপডেট করুন</p>
        <hr>
        <h2>শিক্ষার্থী আইডি: <?php echo htmlspecialchars($student['student_id']); ?></h2>
    </div>

    <?php if ($message): ?>
        <p class="message-success"><?php echo $message; ?></p>
    <?php endif; ?>
    <?php if ($error): ?>
        <p class="message-error"><?php echo $error; ?></p>
    <?php endif; ?>
    
    <form action="edit_student.php?id=<?php echo htmlspecialchars($student_id); ?>" method="POST">
        <div class="form-section">
            <h3>শিক্ষার্থীর তথ্য</h3>
            <div class="form-group">
                <label for="first_name">নামের প্রথম অংশ:</label>
                <input type="text" id="first_name" name="first_name" value="<?php echo htmlspecialchars($student['first_name']); ?>" required>
            </div>
            <div class="form-group">
                <label for="last_name">নামের শেষ অংশ:</label>
                <input type="text" id="last_name" name="last_name" value="<?php echo htmlspecialchars($student['last_name']); ?>" required>
            </div>
            <div class="form-group">
                <label for="father_name">পিতার নাম:</label>
                <input type="text" id="father_name" name="father_name" value="<?php echo htmlspecialchars($student['father_name']); ?>" required>
            </div>
            <div class="form-group">
                <label for="class_roll">শ্রেণি রোল:</label>
                <input type="number" id="class_roll" name="class_roll" value="<?php echo htmlspecialchars($student['class_roll']); ?>" required>
            </div>
            <div class="form-group">
                <label for="class_id">শ্রেণি:</label>
                <select id="class_id" name="class_id" required>
                    <?php
                    if ($classes_result->num_rows > 0) {
                        while($row = $classes_result->fetch_assoc()) {
                            $selected = ($row['class_id'] == $student['class_id']) ? 'selected' : '';
                            echo "<option value='" . htmlspecialchars($row['class_id']) . "' $selected>" . htmlspecialchars($row['class_name']) . "</option>";
                        }
                    } else {
                        echo "<option value=''>কোনো শ্রেণি পাওয়া যায়নি</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="form-group">
                <label for="date_of_birth">জন্ম তারিখ:</label>
                <input type="date" id="date_of_birth" name="date_of_birth" value="<?php echo htmlspecialchars($student['date_of_birth']); ?>" required>
            </div>
            <div class="form-group">
                <label for="gender">লিঙ্গ:</label>
                <div class="radio-group">
                    <input type="radio" id="male" name="gender" value="Male" <?php echo ($student['gender'] == 'Male') ? 'checked' : ''; ?> required>
                    <label for="male">ছেলে</label>
                    <input type="radio" id="female" name="gender" value="Female" <?php echo ($student['gender'] == 'Female') ? 'checked' : ''; ?>>
                    <label for="female">মেয়ে</label>
                    <input type="radio" id="other" name="gender" value="Other" <?php echo ($student['gender'] == 'Other') ? 'checked' : ''; ?>>
                    <label for="other">অন্যান্য</label>
                </div>
            </div>
        </div>

        <div class="form-section">
            <h3>যোগাযোগের তথ্য</h3>
            <div class="form-group">
                <label for="phone_number">মোবাইল:</label>
                <input type="text" id="phone_number" name="phone_number" value="<?php echo htmlspecialchars($student['phone_number']); ?>" required>
            </div>
            <div class="form-group">
                <label for="address">ঠিকানা:</label>
                <textarea id="address" name="address" required><?php echo htmlspecialchars($student['address']); ?></textarea>
            </div>
        </div>
        
        <div class="form-section">
            <h3>অন্যান্য তথ্য</h3>
            <div class="form-group">
                <label for="fixed_fee">ধার্যকৃত মাসিক বেতন:</label>
                <input type="number" step="0.01" id="fixed_fee" name="fixed_fee" value="<?php echo htmlspecialchars($student['fixed_fee']); ?>" required>
            </div>
        </div>
        
        <div class="form-buttons">
            <button type="submit">আপডেট করুন</button>
            <a href="students_list.php" class="button">তালিকা দেখুন</a>
        </div>
    </form>
</div>

<?php
$conn->close();
?>

<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
</div>
</div>
</body>
</html>