<?php
session_start();

// --- ফাইল ইনক্লুড করার জন্য সবচেয়ে নির্ভরযোগ্য রুট পাথ লজিক ---

$ds = DIRECTORY_SEPARATOR;
$project_root_raw = dirname(dirname(__DIR__)); 
$project_root_1 = rtrim($project_root_raw, '/\\'); 

// তিনটি সম্ভাব্য পাথ কনফিগার করা হলো ( db_connection.php, functions.php )
$db_paths = [
    $project_root_1 . $ds . 'includes' . $ds . 'db_connection.php',
    $project_root_1 . $ds . 'includes' . $ds . 'db_connection', // এক্সটেনশন ছাড়া চেষ্টা
];
$functions_paths = [
    $project_root_1 . $ds . 'includes' . $ds . 'functions.php',
];

$found = false;
$db_path = null;
$functions_path = null;

// db_connection ফাইল খুঁজে বের করার চেষ্টা
foreach ($db_paths as $path) {
    if (file_exists($path)) {
        $db_path = $path;
        break;
    }
}

// functions.php ফাইল খুঁজে বের করার চেষ্টা
foreach ($functions_paths as $path) {
    if (file_exists($path)) {
        $functions_path = $path;
        break;
    }
}

// ৩. ফাইল ইনক্লুড করা
if ($db_path && $functions_path) {
    include $db_path;
    include $functions_path;
    $found = true;
} 

// যদি প্রথম চেষ্টা ব্যর্থ হয়, তবে realpath ব্যবহার করে আপেক্ষিক পাথ খোঁজা
if (!$found) {
    $relative_db_path = '..' . $ds . '..' . $ds . '..' . $ds . 'includes' . $ds . 'db_connection';
    $relative_functions_path = '..' . $ds . '..' . $ds . '..' . $ds . 'includes' . $ds . 'functions.php';
    
    $real_db_path = realpath($relative_db_path);
    $real_functions_path = realpath($relative_functions_path);

    if ($real_db_path && $real_functions_path) {
        include $real_db_path;
        include $real_functions_path;
        $found = true;
    }
}

if (!$found) {
     // চূড়ান্ত ব্যর্থতা: ফাইল না পেলে এক্সিকিউশন বন্ধ করা হলো
    die("FATAL ERROR: Required core files (db_connection or functions) not found. Please ensure 'db_connection.php' and 'functions.php' exist in the 'includes' folder.");
}

// লগইন ও অনুমতি চেক
if (!is_logged_in() || (isset($_SESSION['role']) && $_SESSION['role'] !== 'Admin')) {
    // পাথ public/students/ থেকে /public/index.php এ যেতে হবে
    redirect_to('../../index.php'); 
}

// পরীক্ষার তালিকা ফেচ করা
// 'exam_year' কলামটি আপনার টেবিলে নেই, তাই এটি বাদ দেওয়া হয়েছে।
$exams_sql = "SELECT exam_id, exam_name FROM exams ORDER BY exam_id DESC";
$exams_result = $conn->query($exams_sql);

if (!$exams_result) {
    // ক্যোয়ারি ব্যর্থ হলে একটি স্পষ্ট মেসেজ দেখাবে
    die("ERROR: Failed to fetch exams data. Check if 'exams' table exists and the query is correct. MySQL Error: " . $conn->error);
}

// শ্রেণির তালিকা ফেচ করা
$classes_sql = "SELECT class_id, class_name FROM classes ORDER BY class_id";
$classes_result = $conn->query($classes_sql);

$conn->close();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>প্রবেশপত্র জেনারেটর</title>
    <!-- CSS পাথ ঠিক করা হয়েছে -->
    <link rel="stylesheet" href="../../css/style.css"> 
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .generator-form-container {
            max-width: 600px;
            margin: 50px auto;
            padding: 30px;
            background-color: #fff;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        }
        .generator-form-container h2 {
            color: #34495e;
            text-align: center;
            margin-bottom: 25px;
            font-size: 24px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #555;
        }
        .form-group select, .form-group input[type="text"] {
            width: 100%;
            padding: 10px 15px;
            border: 1px solid #ddd;
            border-radius: 6px;
            box-sizing: border-box;
            font-size: 16px;
            background-color: #f9f9f9;
        }
        .btn-generate {
            display: block;
            width: 100%;
            padding: 12px;
            background-color: #2ecc71;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 18px;
            font-weight: bold;
            cursor: pointer;
            transition: background-color 0.3s ease, transform 0.1s;
        }
        .btn-generate:hover {
            background-color: #27ae60;
            transform: translateY(-1px);
        }
    </style>
</head>
<body>
<div class="header">
    <h1>প্রবেশপত্র জেনারেটর</h1>
</div>
<div class="content">
    <div class="container generator-form-container">
        <div class="back-button-container">
            <!-- ড্যাশবোর্ড বাটন পাথ ঠিক করা হয়েছে (public/students/ থেকে public/dashboard.php এ যেতে) -->
            <a href="../../public/dashboard.php" class="back-button"><i class="fas fa-arrow-left"></i> ড্যাশবোর্ড</a>
        </div>
        <h2>পরীক্ষার প্রবেশপত্র তৈরি</h2>
        
        <form action="generate_admit_cards.php" method="GET"> <!-- অ্যাকশন শুধুমাত্র ফাইলের নাম দেওয়া হলো, ধরে নিচ্ছি একই ফোল্ডারে আছে -->
            <div class="form-group">
                <label for="exam_id"><i class="fas fa-file-alt"></i> পরীক্ষার নাম নির্বাচন করুন:</label>
                <select id="exam_id" name="exam_id" required>
                    <option value="">-- পরীক্ষা বাছুন --</option>
                    <?php 
                    if ($exams_result && $exams_result->num_rows > 0) {
                        while($row = $exams_result->fetch_assoc()) {
                            // 'exam_year' কলাম আর নেই, তাই শুধু exam_name দেখানো হবে
                            echo "<option value='{$row['exam_id']}'>" . htmlspecialchars($row['exam_name']) . "</option>";
                        }
                    } else {
                        echo "<option value='' disabled>কোনো পরীক্ষা সেট করা নেই।</option>";
                    }
                    ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="class_id"><i class="fas fa-chalkboard-teacher"></i> শ্রেণি নির্বাচন করুন (ঐচ্ছিক):</label>
                <select id="class_id" name="class_id">
                    <option value="">-- সকল শ্রেণি --</option>
                    <?php 
                    if ($classes_result && $classes_result->num_rows > 0) {
                        while($row = $classes_result->fetch_assoc()) {
                            echo "<option value='{$row['class_id']}'>" . htmlspecialchars($row['class_name']) . "</option>";
                        }
                    }
                    ?>
                </select>
            </div>
            
            <button type="submit" class="btn-generate">
                <i class="fas fa-print"></i> প্রবেশপত্র তৈরি ও প্রিন্ট প্রিভিউ
            </button>
        </form>
    </div>
</div>
<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
</div>
</body>
</html>
