<?php
session_start();
include '../../includes/db_connection.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}

if ($_SESSION['role'] !== 'Admin') {
    echo "<p style='color:red;'>আপনার এই পেজ দেখার অনুমতি নেই।</p>";
    exit();
}

$message = '';
$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // পোস্ট থেকে ডেটা সংগ্রহ
    $first_name = $_POST['first_name'];
    $last_name = $_POST['last_name'];
    $father_name = $_POST['father_name'];
    $mother_name = $_POST['mother_name'];
    $village = $_POST['village'];
    $district = $_POST['district'];
    $upazila = $_POST['upazila'];
    $birth_reg_no = $_POST['birth_reg_no'];
    
    $class_roll = $_POST['class_roll'];
    $date_of_birth = $_POST['date_of_birth'];
    $gender = $_POST['gender'];
    $phone_number = $_POST['phone_number'];
    $address = $_POST['address'];
    $class_id = $_POST['class_id'];
    $fixed_fee = $_POST['fixed_fee'];
    $enrollment_date = date('Y-m-d');
    
    // **নতুন ডেটা সংগ্রহ**
    $previous_institute = $_POST['previous_institute'] ?? '';
    $photo_path = null; 

    // --- ছবি আপলোড হ্যান্ডেল করা ---
    if (isset($_FILES['student_photo']) && $_FILES['student_photo']['error'] == 0) {
        // ফাইলটি school_management/public/uploads/student_photos/ এই পাথে সেভ হবে
        $target_dir = "../../public/uploads/student_photos/"; 

        // আপলোড ফোল্ডার না থাকলে তৈরি করা
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0777, true);
        }

        $original_file_name = basename($_FILES["student_photo"]["name"]);
        $file_extension = strtolower(pathinfo($original_file_name, PATHINFO_EXTENSION));
        // ছবির নাম তৈরি: std_timestamp_uniqueid.ext
        $new_file_name = "std_" . time() . "_" . uniqid() . "." . $file_extension;
        $target_file = $target_dir . $new_file_name;
        
        // শুধু JPEG, PNG, GIF ফাইল অনুমোদিত
        if (in_array($file_extension, ['jpg', 'jpeg', 'png', 'gif'])) {
            // ফাইলটি নির্ধারিত স্থানে সরানো
            if (move_uploaded_file($_FILES["student_photo"]["tmp_name"], $target_file)) {
                // ডাটাবেসে সংরক্ষণের জন্য ফাইল পাথ সেট করা
                // public ফোল্ডার থেকে শুরু করে পাথ সেভ করা হলো
                $photo_path = "uploads/student_photos/" . $new_file_name; 
            } else {
                $error = "ছবি আপলোড করতে সমস্যা হয়েছে। ফোল্ডারের অনুমতি (Permission) চেক করুন।";
            }
        } else {
            $error = "শুধুমাত্র JPG, JPEG, PNG, ও GIF ফাইল আপলোড করা যাবে।";
        }
    }
    // --- ছবি আপলোড হ্যান্ডেল করা শেষ ---

    // যদি কোনো ত্রুটি না থাকে তবে ডাটাবেসে সংরক্ষণ করা হবে
    if (empty($error)) {
        // SQL কোয়েরি: নতুন কলাম সহ (previous_institute, photo_path যোগ করা হয়েছে)
        $sql = "INSERT INTO students (first_name, last_name, father_name, mother_name, village, district, upazila, birth_reg_no, class_roll, date_of_birth, gender, phone_number, address, class_id, fixed_fee, enrollment_date, previous_institute, photo_path) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        $stmt = $conn->prepare($sql);
        
        if ($stmt === false) {
            $error = "SQL কোয়েরিতে সমস্যা: " . $conn->error;
        } else {
            // bind_param: মোট ১৮টি প্যারামিটার: sssssssisdsidsss
            $stmt->bind_param("sssssssssisdsidsss", 
                $first_name, $last_name, $father_name, $mother_name, $village, $district, $upazila, $birth_reg_no, 
                $class_roll, 
                $date_of_birth, $gender, $phone_number, $address, 
                $class_id, 
                $fixed_fee, 
                $enrollment_date,
                $previous_institute, // নতুন কলাম ১
                $photo_path          // নতুন কলাম ২
            );

            if ($stmt->execute()) {
                $message = "নতুন শিক্ষার্থী সফলভাবে যুক্ত করা হয়েছে!";
            } else {
                if ($conn->errno == 1062) {
                    $error = "ভর্তি ব্যর্থ: জন্ম নিবন্ধন নম্বরটি ('" . htmlspecialchars($birth_reg_no) . "') ইতিমধ্যেই নিবন্ধিত আছে।";
                } else {
                     $error = "সমস্যা: " . htmlspecialchars($stmt->error);
                }
            }
            $stmt->close();
        }
    }
}

// Fetch classes for the dropdown
$classes_sql = "SELECT class_id, class_name FROM classes ORDER BY class_name";
$classes_result = $conn->query($classes_sql);
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ভর্তি ফরম | মিফতাহুন নাজাত মহিলা মাদরাসা</title>
    <link rel="stylesheet" href="/school_management/public/css/style.css">
    <style>
        /* A4 Page and Form Styling (আগের স্টাইলগুলো এখানে থাকবে) */
        body { font-family: 'Arial', sans-serif; background-color: #f4f4f4; margin: 0; padding: 20px; }
        .container { width: 210mm; min-height: 297mm; background-color: white; padding: 30px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); margin: 20px auto; }
        .admission-form-header { text-align: center; border-bottom: 2px solid #333; padding-bottom: 10px; margin-bottom: 20px; }
        .admission-form-header h1, .admission-form-header h2 { font-size: 24px; margin: 5px 0; }
        .admission-form-header p { font-size: 14px; margin: 0; color: #555; }
        .form-section { margin-bottom: 25px; padding: 15px; border: 1px solid #ccc; border-radius: 5px; }
        .form-section h3 { margin-top: 0; color: #004d40; border-bottom: 1px solid #004d40; padding-bottom: 5px; }
        .form-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 15px; } /* গ্রিড লেআউট যোগ করা হয়েছে */
        .form-group { margin-bottom: 0; display: flex; flex-direction: column; } /* flex-direction column করা হয়েছে */
        .form-group.full-width { grid-column: 1 / -1; } /* ফুল উইডথ কলামের জন্য */
        .form-group label { font-weight: bold; color: #444; margin-bottom: 5px; }
        .form-group input[type="text"], .form-group input[type="number"], .form-group input[type="date"], .form-group select, .form-group textarea, .form-group input[type="file"] { padding: 8px; border: 1px solid #ccc; border-radius: 4px; font-size: 14px; width: 100%; box-sizing: border-box; }
        .form-group textarea { height: 60px; }
        .form-group .radio-group { display: flex; gap: 20px; padding-top: 5px; }
        .form-buttons { text-align: center; margin-top: 30px; }
        .form-buttons button, .form-buttons a { padding: 12px 25px; font-size: 16px; cursor: pointer; border: none; border-radius: 5px; color: white; background-color: #007bff; transition: background-color 0.3s; text-decoration: none; display: inline-block; margin: 0 5px; }
        .form-buttons button:hover, .form-buttons a:hover { background-color: #0056b3; }
        .message-success { color: green; text-align: center; font-weight: bold; }
        .message-error { color: red; text-align: center; font-weight: bold; }
        @media print {
            body { background-color: white; margin: 0; padding: 0; }
            .header, .nav, .footer, .form-buttons { display: none; }
            .container { width: 210mm; min-height: 297mm; box-shadow: none; margin: 0; padding: 15mm; }
            .form-group input, .form-group select, .form-group textarea { border: none; border-bottom: 1px dotted #000; border-radius: 0; }
        }
    </style>
</head>
<body>
<div class="header">
    <h1>স্কুল ম্যানেজমেন্ট সিস্টেম</h1>
    <div class="nav">
        <a href="/school_management/public/dashboard.php">ড্যাশবোর্ড</a>
        <a href="/school_management/public/students/students_list.php">শিক্ষার্থী</a>
        <a href="/school_management/public/teachers/teachers_list.php">শিক্ষক</a>
        <a href="/school_management/public/fees/fee_collection.php">ফি সংগ্রহ</a>
        <a href="/school_management/public/subjects/subjects_list.php">বিষয়সমূহ</a>
        <a href="/school_management/public/exam_results/add_exam_result.php">পরীক্ষা</a>
        <a href="/school_management/public/attendance/record_attendance.php">উপস্থিতি</a>
        <a href="/school_management/public/change_password.php">পাসওয়ার্ড পরিবর্তন</a>
        <a href="/school_management/public/logout.php">লগআউট</a>
    </div>
</div>
<div class="content">

<div class="container">
    <div class="admission-form-header">
        <h1>মিফতাহুন নাজাত মহিলা মাদরাসা</h1>
        <p>নেয়ামতপুর সদর, নোয়াখালী</p>
        <hr>
        <h2>ভর্তি ফরম</h2>
    </div>

    <?php if ($message): ?>
        <p class="message-success"><?php echo $message; ?></p>
    <?php endif; ?>
    <?php if ($error): ?>
        <p class="message-error"><?php echo $error; ?></p>
    <?php endif; ?>
    
    <form action="" method="POST" enctype="multipart/form-data"> 
        <div class="form-section">
            <h3>১. শিক্ষার্থীর ব্যক্তিগত তথ্য</h3>
            <div class="form-grid">
                <div class="form-group">
                    <label for="first_name">নামের প্রথম অংশ:</label>
                    <input type="text" id="first_name" name="first_name" required>
                </div>
                <div class="form-group">
                    <label for="last_name">নামের শেষ অংশ:</label>
                    <input type="text" id="last_name" name="last_name" required>
                </div>
                <div class="form-group">
                    <label for="date_of_birth">জন্ম তারিখ:</label>
                    <input type="date" id="date_of_birth" name="date_of_birth" required>
                </div>
                
                <div class="form-group">
                    <label for="birth_reg_no">জন্ম নিবন্ধন নং:</label>
                    <input type="text" id="birth_reg_no" name="birth_reg_no" required>
                </div>
                
                <div class="form-group">
                    <label for="gender">লিঙ্গ:</label>
                    <div class="radio-group">
                        <input type="radio" id="male" name="gender" value="Male" required>
                        <label for="male">ছেলে</label>
                        <input type="radio" id="female" name="gender" value="Female">
                        <label for="female">মেয়ে</label>
                        <input type="radio" id="other" name="gender" value="Other">
                        <label for="other">অন্যান্য</label>
                    </div>
                </div>

                <div class="form-group full-width">
                    <label for="previous_institute">পূর্ববর্তী প্রতিষ্ঠানের নাম (ঐচ্ছিক):</label>
                    <input type="text" id="previous_institute" name="previous_institute" placeholder="যদি অন্য কোনো প্রতিষ্ঠান থেকে এসে থাকে">
                </div>
                
                <div class="form-group full-width">
                    <label for="student_photo">শিক্ষার্থীর ছবি (JPG/PNG):</label>
                    <input type="file" id="student_photo" name="student_photo" accept="image/jpeg,image/png,image/gif">
                </div>
                
            </div>
        </div>

        <div class="form-section">
            <h3>২. পিতা-মাতার তথ্য</h3>
            <div class="form-grid">
                <div class="form-group">
                    <label for="father_name">পিতার নাম:</label>
                    <input type="text" id="father_name" name="father_name" required>
                </div>
                <div class="form-group">
                    <label for="mother_name">মাতার নাম:</label>
                    <input type="text" id="mother_name" name="mother_name" required>
                </div>
            </div>
        </div>

        <div class="form-section">
            <h3>৩. ঠিকানা ও যোগাযোগ</h3>
            <div class="form-grid">
                <div class="form-group">
                    <label for="phone_number">মোবাইল:</label>
                    <input type="text" id="phone_number" name="phone_number" required>
                </div>
                <div class="form-group">
                    <label for="village">গ্রাম:</label>
                    <input type="text" id="village" name="village" required>
                </div>
                <div class="form-group">
                    <label for="upazila">উপজেলা/থানা:</label>
                    <input type="text" id="upazila" name="upazila" required>
                </div>
                <div class="form-group">
                    <label for="district">জেলা:</label>
                    <input type="text" id="district" name="district" required>
                </div>
                <div class="form-group full-width">
                    <label for="address">অন্যান্য ঠিকানা (বিস্তারিত):</label>
                    <textarea id="address" name="address" required></textarea>
                </div>
            </div>
        </div>
        
        <div class="form-section">
            <h3>৪. শিক্ষা ও ফি</h3>
            <div class="form-grid">
                <div class="form-group">
                    <label for="class_id">শ্রেণি:</label>
                    <select id="class_id" name="class_id" required>
                        <?php
                        if ($classes_result->num_rows > 0) {
                            $classes_result->data_seek(0); // আবার প্রথম থেকে শুরু করা হলো
                            while($row = $classes_result->fetch_assoc()) {
                                echo "<option value='" . htmlspecialchars($row['class_id']) . "'>" . htmlspecialchars($row['class_name']) . "</option>";
                            }
                        } else {
                            echo "<option value=''>কোনো শ্রেণি পাওয়া যায়নি</option>";
                        }
                        ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="class_roll">শ্রেণি রোল:</label>
                    <input type="number" id="class_roll" name="class_roll" required>
                </div>
                <div class="form-group">
                    <label for="fixed_fee">ধার্যকৃত মাসিক বেতন:</label>
                    <input type="number" step="0.01" id="fixed_fee" name="fixed_fee" required>
                </div>
            </div>
        </div>
        
        <div class="form-buttons">
            <button type="submit">শিক্ষার্থী যুক্ত করুন</button>
            <button type="button" onclick="window.print()">প্রিন্ট করুন</button>
            <a href="students_list.php" class="button">তালিকা দেখুন</a>
        </div>
    </form>
</div>

<?php
if (isset($conn) && $conn->ping()) {
    $conn->close();
}
?>

<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
</div>
</div>
</body>
</html>