<?php
// C:\xampp\htdocs\school_management\public\routines\save_multiple_routine.php

// ----------------------------------------------------
// **১. ডিবাগিং এর জন্য এরর ডিসপ্লে চালু করুন (সমস্যা সমাধানে সাহায্য করবে)**
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
// ----------------------------------------------------


// 2. ডেটাবেস কানেকশন অন্তর্ভুক্ত করা
include '../../includes/db_connection.php'; 

// 3. ডেটাবেস কানেকশন যাচাই
if ($conn->connect_error) {
    header("Location: routine_form.php?error=" . urlencode("ডেটাবেস কানেকশন ব্যর্থ: " . $conn->connect_error));
    exit();
}

// 4. POST ডেটা যাচাই ও প্রক্রিয়াকরণ
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['routines']) && is_array($_POST['routines'])) {
    
    $routines = $_POST['routines'];
    $success_count = 0;
    $error_messages = [];
    
    // SQL ইনসার্ট ক্যোয়ারি প্রস্তুত করা (Prepared Statement)
    // কলামগুলো: class_id, routine_type, exam_id, subject_id, teacher_id, exam_date, start_time, end_time, session_type
    //
    $sql = "INSERT INTO routines 
            (class_id, routine_type, exam_id, subject_id, teacher_id, exam_date, start_time, end_time, session_type) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        $error_messages[] = "SQL প্রস্তুতি ব্যর্থ (QUERY ERROR): " . $conn->error;
        goto finalize; 
    }
    
    // ডেটা টাইপ বাইন্ডিং
    // "isiiissss" : class_id(i), routine_type(s), exam_id(i), subject_id(i), teacher_id(i), exam_date(s), start_time(s), end_time(s), session_type(s)
    $stmt->bind_param("isiiissss", 
        $class_id, $routine_type, $exam_id, $subject_id, $teacher_id, $exam_date, $start_time, $end_time, $session_type
    );

    // 5. প্রতিটি রুটিন এন্ট্রি লুপ করা
    foreach ($routines as $index => $routine) {
        
        // ডেটা ভ্যালিডেশন
        if (empty($routine['class_id']) || empty($routine['subject_id']) || empty($routine['teacher_id']) || empty($routine['exam_date']) || empty($routine['start_time']) || empty($routine['end_time'])) {
            $error_messages[] = "Row " . ($index + 1) . ": কিছু আবশ্যিক ফিল্ড খালি ছিল। এন্ট্রি বাতিল করা হলো।";
            continue; 
        }
        
        // ভেরিয়েবল সেট করা
        $class_id       = intval($routine['class_id']);
        $routine_type   = trim($routine['routine_type']);
        $subject_id     = intval($routine['subject_id']);
        $teacher_id     = intval($routine['teacher_id']);
        $exam_date      = trim($routine['exam_date']); // DB কলামের নাম: exam_date
        $start_time     = trim($routine['start_time']);
        $end_time       = trim($routine['end_time']);
        $session_type   = trim($routine['session_type']);
        
        // exam_id হ্যান্ডলিং
        $exam_id = 0; 
        if ($routine_type === 'exam' && !empty($routine['exam_id'])) {
            $exam_id = intval($routine['exam_id']);
        }

        // 6. ক্যোয়ারি এক্সিকিউট করা
        if ($stmt->execute()) {
            $success_count++;
        } else {
            // **এইটি সবচেয়ে গুরুত্বপূর্ণ এরর মেসেজ!**
            $error_messages[] = "Row " . ($index + 1) . " সেভ করতে ব্যর্থ (EXECUTE ERROR): " . $stmt->error;
        }
    }
    
    $stmt->close();

    // 7. ফলাফল অনুযায়ী ব্যবহারকারীকে রুটিন ফর্মে ফেরত পাঠানো
    finalize:
    
    if (isset($conn)) {
        $conn->close();
    }

    if (!empty($error_messages)) {
        $error_string = implode("; ", $error_messages);
        if ($success_count > 0) {
            $error_string = "সফলভাবে " . $success_count . "টি এন্ট্রি সেভ হয়েছে, কিন্তু কিছু ত্রুটি ছিল: " . $error_string;
        }
        header("Location: routine_form.php?error=" . urlencode($error_string));
    } else {
        header("Location: routine_form.php?message=" . urlencode("সফলভাবে " . $success_count . "টি নতুন রুটিন এন্ট্রি ডেটাবেসে যুক্ত করা হয়েছে।"));
    }
    
} else {
    header("Location: routine_form.php?error=" . urlencode("অবৈধ রিকোয়েস্ট বা কোনো রুটিন ডেটা পাঠানো হয়নি।"));
}

exit();
?>