<?php
session_start();
include '../../includes/db_connection.php'; 

if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}

$message = '';
$error = '';

// --- হ্যান্ডেল ডিলিট অপারেশন ---
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['delete_income_id'])) {
    if ($_SESSION['role'] === 'Admin') {
        $income_id = $_POST['delete_income_id'];
        $sql = "DELETE FROM other_incomes WHERE income_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $income_id);
        if ($stmt->execute()) {
            $message = "আয়ের হিসাব সফলভাবে মুছে ফেলা হয়েছে!";
        } else {
            $error = "হিসাব মোছার সময় সমস্যা হয়েছে: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $error = "মুছে ফেলার অনুমতি নেই।";
    }
}
// --- শেষ ডিলিট অপারেশন ---

// --- হ্যান্ডেল সার্চ এবং ফিল্টার ---
$search_memo = $_GET['search_memo'] ?? '';
$search_source = $_GET['search_source'] ?? '';
$where_clauses = [];
$param_types = '';
$param_values = [];

// 1. মেমো নং দিয়ে সার্চ
if (!empty($search_memo)) {
    $where_clauses[] = "i.memo_no LIKE ?";
    $param_types .= 's';
    $param_values[] = '%' . $search_memo . '%';
}

// 2. আয়ের উৎস দিয়ে সার্চ
if (!empty($search_source)) {
    $where_clauses[] = "i.income_source = ?";
    $param_types .= 's';
    $param_values[] = $search_source; 
}

$where_sql = count($where_clauses) > 0 ? " WHERE " . implode(" AND ", $where_clauses) : "";


// আয়ের তথ্য সংগ্রহ
$sql = "SELECT i.*, u.username as receiver_name 
        FROM other_incomes i
        LEFT JOIN users u ON i.received_by = u.user_id "
        . $where_sql . 
        " ORDER BY i.income_date DESC, i.income_id DESC";

$incomes = [];
$total_income = 0;

if (count($param_values) > 0) {
    // প্যারামিটার বাইন্ড করে স্টেটমেন্ট এক্সিকিউট করা
    $stmt = $conn->prepare($sql);
    $stmt->bind_param($param_types, ...$param_values);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    // কোনো সার্চ বা ফিল্টার না থাকলে সরাসরি কোয়েরি
    $result = $conn->query($sql);
}


if ($result && $result->num_rows > 0) {
    $incomes = $result->fetch_all(MYSQLI_ASSOC);
    // কেবল সার্চ করা ডেটার মোট আয় গণনা করা হচ্ছে
    foreach ($incomes as $income) {
        $total_income += $income['amount'];
    }
}


// ডাটাবেস থেকে সকল আয়ের উৎসের তালিকা লোড করা (ড্রপডাউনের জন্য)
$sources_sql = "SELECT DISTINCT income_source FROM other_incomes ORDER BY income_source ASC";
$sources_result = $conn->query($sources_sql);
$income_sources_list = [];
if ($sources_result && $sources_result->num_rows > 0) {
    while ($row = $sources_result->fetch_assoc()) {
        $income_sources_list[] = $row['income_source'];
    }
}


// conn বন্ধ করা
$conn->close();
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>অন্যান্য আয়ের তালিকা</title>
    <link rel="stylesheet" href="../../public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Base Styles for Table (অপরিবর্তিত) */
        .list-container { margin-top: 20px; overflow-x: auto; }
        .list-container table { 
            width: 100%; 
            min-width: 800px; 
            border-collapse: collapse; 
            margin-top: 20px; 
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }
        .list-container th, .list-container td { 
            border: 1px solid #e0e0e0; 
            padding: 12px 10px; 
            text-align: left; 
            font-size: 14px; 
            white-space: nowrap; 
        }
        .list-container th { 
            background-color: #34495e; 
            color: white; 
            font-weight: bold;
            text-transform: uppercase;
        }
        .list-container tr:nth-child(even) { background-color: #f8f8f8; }
        .list-container tr:hover { background-color: #f1f1f1; }

        .actions a, .actions button { 
            margin-right: 5px; 
            padding: 6px 10px; 
            border-radius: 4px; 
            font-size: 13px; 
            text-decoration: none; 
            border: none; 
            cursor: pointer; 
            transition: background-color 0.3s;
        }
        .actions .edit-btn { background-color: #3498db; color: white; }
        .actions .delete-btn { background-color: #e74c3c; color: white; }
        
        .summary-box { 
            background-color: #ecf0f1; 
            border: 1px solid #bdc3c7; 
            padding: 20px; 
            border-radius: 8px; 
            margin-bottom: 25px; 
            font-size: 20px; 
            font-weight: bold; 
            color: #2c3e50; 
            text-align: center; 
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        
        /* Control Group and Search Form Styles (অপরিবর্তিত) */
        .control-group {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
            flex-wrap: wrap; 
        }

        .search-filter-compact {
            display: flex;
            gap: 10px;
            align-items: center;
            padding: 10px;
            background-color: #eef2f5;
            border-radius: 6px;
            margin-bottom: 10px;
            width: 100%;
        }
        .search-filter-compact input[type="text"], 
        .search-filter-compact select {
            padding: 8px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 14px;
            flex-grow: 1;
            max-width: 250px;
        }
        .search-filter-compact select { max-width: 200px; }
        .search-filter-compact button {
            padding: 8px 12px;
            background-color: #2980b9;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
            transition: background-color 0.3s;
        }
        .search-filter-compact button:hover { background-color: #1a6f9c; }
        .search-filter-compact button.reset-btn { background-color: #7f8c8d; }
        .search-filter-compact button.reset-btn:hover { background-color: #636e72; }
        
        /* Other Button Styles (অপরিবর্তিত) */
        .control-group .left-buttons a, .control-group .right-buttons a, .control-group .right-buttons button {
            padding: 10px 15px;
            border-radius: 4px;
            text-decoration: none;
            font-weight: bold;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            margin-right: 10px;
            transition: background-color 0.3s;
        }
        .control-group .left-buttons a.add-btn { background-color: #2ecc71; color: white; }
        .control-group .left-buttons a.report-btn { background-color: #f39c12; color: white; }
        .back-button { background-color: #34495e; color: white; border: none; }
        .print-button { background-color: #3498db; color: white; border: none; }
        
        /* স্কুল হেডার প্রিন্ট-এর জন্য (নন-প্রিন্ট মোডে লুকানো) */
        .school-header-print {
            display: none; /* ডিফল্টভাবে লুকানো থাকবে */
            text-align: center;
            margin-bottom: 20px;
        }
        .school-header-print h3, .school-header-print p, .school-header-print h4 {
            margin: 5px 0;
            color: #000;
        }

        /* প্রিন্ট মিডিয়া কোয়েরি (পরিবর্তন করা হয়েছে) */
        @media print {
            body { padding-top: 0 !important; background-color: white !important; }
            /* অপ্রয়োজনীয় অংশগুলো লুকানো */
            .header, .nav, .control-group, .footer, .actions, .search-filter-compact { 
                display: none !important; 
            }
            .container { box-shadow: none !important; margin: 0; padding: 0; }
            
            /* স্কুলের হেডার প্রিন্ট করার সময় দেখানো */
            .school-header-print { 
                display: block !important; 
            }
            
            .summary-box { margin-top: 10px; }
            
            /* টেবিল স্টাইল */
            .list-container table { width: 100%; font-size: 12px; min-width: auto; }
            .list-container th, .list-container td { padding: 6px 4px; border-color: #000; white-space: normal; word-wrap: break-word; }
            .list-container th { background-color: #ccc !important; color: #000 !important; -webkit-print-color-adjust: exact; print-color-adjust: exact; }
            
            /* পেজ ওরিয়েন্টেশন পোর্ট্রেট করা হয়েছে */
            @page { 
                size: A4 portrait; /* Portrait মোড */
                margin: 1cm; 
            }
        }
    </style>
</head>
<body>
<div class="header">
    <h1>স্কুল ম্যানেজমেন্ট সিস্টেম</h1>
    <div class="nav">
        <a href="/school_management/public/dashboard.php">ড্যাশবোর্ড</a>
        <a href="/school_management/public/students/students_list.php">শিক্ষার্থী</a>
        <a href="/school_management/public/teachers/teachers_list.php">শিক্ষক</a>
        <a href="/school_management/public/fees/fee_collection.php">ফি সংগ্রহ</a>
        <a href="/school_management/public/incomes/income_list.php">অন্যান্য আয়</a>
        <a href="/school_management/public/fees/monthly_fee_summary.php">মাসিক রিপোর্ট</a>
        <a href="/school_management/public/classes/classes_list.php">শ্রেণি</a>
        <a href="/school_management/public/subjects/subjects_list.php">বিষয়</a>
        <a href="/school_management/public/exam_results/add_exam_result.php">পরীক্ষা</a>
        <a href="/school_management/public/exam_results/exam_report.php">পরীক্ষার রিপোর্ট</a>
        <a href="/school_management/public/attendance/record_attendance.php">উপস্থিতি</a>
        <a href="/school_management/public/attendance/attendance_report.php">উপস্থিতি রিপোর্ট</a>
        <a href="/school_management/public/change_password.php">পাসওয়ার্ড পরিবর্তন</a>
        <a href="/school_management/public/logout.php">লগআউট</a>
    </div>
</div>
<div class="content">
    <div class="container">
        
        <div class="school-header-print">
            <h3>মিফতাহুন নাজাত মহিলা মাদরাসা</h3>
            <p>নেয়ামতপুর,সদর,নোয়াখালী</p>
            <h4>অন্যান্য আয়ের তালিকা</h4>
        </div>
        
        <h2>অন্যান্য আয়ের তালিকা</h2>
        
        <div class="summary-box">
            <i class="fas fa-money-bill-wave"></i> মোট সংগৃহীত আয়: **<?php echo number_format($total_income, 2); ?> টাকা**
        </div>
        
        <?php if ($message): ?><p class="message-success" style='color:green; background-color: #e8f5e9; padding: 10px;'><i class="fas fa-check-circle"></i> <?php echo $message; ?></p><?php endif; ?>
        <?php if ($error): ?><p class="message-error" style='color:red; background-color: #fbecec; padding: 10px;'><i class="fas fa-exclamation-triangle"></i> <?php echo $error; ?></p><?php endif; ?>

        <form method="GET" action="" class="search-filter-compact">
            <input type="text" name="search_memo" placeholder="মেমো নং..." value="<?php echo htmlspecialchars($search_memo); ?>">
            
            <select name="search_source">
                <option value="">-- সব উৎস --</option>
                <?php foreach ($income_sources_list as $source): ?>
                    <option value="<?php echo htmlspecialchars($source); ?>" 
                            <?php echo ($search_source === $source) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($source); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            
            <button type="submit"><i class="fas fa-search"></i></button>
            <button type="button" class="reset-btn" onclick="window.location.href='income_list.php'"><i class="fas fa-redo"></i></button>
        </form>
        <div class="control-group">
            <div class="left-buttons">
                <a href="add_income.php" class="button add-btn"><i class="fas fa-plus-circle"></i> নতুন আয় যুক্ত করুন</a>
                <a href="income_report.php" class="button report-btn"><i class="fas fa-chart-bar"></i> আয়ের রিপোর্ট দেখুন</a>
            </div>
            <div class="right-buttons">
                <a href="/school_management/public/dashboard.php" class="button back-button"><i class="fas fa-arrow-left"></i> ব্যাক</a>
                <button onclick="window.print()" class="button print-button"><i class="fas fa-print"></i> প্রিন্ট করুন</button>
            </div>
        </div>
        
        <div class="list-container">
            <table>
                <thead>
                    <tr>
                        <th>আইডি</th>
                        <th>আয়ের তারিখ</th>
                        <th>মেমো নং</th> 
                        <th>উৎস</th>
                        <th>পরিমাণ (টাকা)</th>
                        <th>বিবরণ</th>
                        <th>গ্রহণকারী</th>
                        <th>অ্যাকশন</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($incomes)): ?>
                        <?php foreach($incomes as $row): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['income_id']); ?></td>
                                <td><?php echo htmlspecialchars(date('d-m-Y', strtotime($row['income_date']))); ?></td>
                                <td><?php echo htmlspecialchars($row['memo_no'] ?? '-'); ?></td> 
                                <td><?php echo htmlspecialchars($row['income_source']); ?></td>
                                <td><?php echo number_format($row['amount'], 2); ?></td>
                                <td><?php echo htmlspecialchars($row['description']); ?></td>
                                <td><?php echo htmlspecialchars($row['receiver_name'] ? $row['receiver_name'] : 'N/A'); ?></td>
                                <td class="actions">
                                    <a href="edit_income.php?id=<?php echo htmlspecialchars($row['income_id']); ?>" class="edit-btn" title="সম্পাদনা">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <?php if ($_SESSION['role'] === 'Admin'): ?>
                                        <form method="POST" action="" style="display:inline-block;">
                                            <input type="hidden" name="delete_income_id" value="<?php echo htmlspecialchars($row['income_id']); ?>">
                                            <button type="submit" class="delete-btn" onclick="return confirm('আপনি কি নিশ্চিত যে এই হিসাবটি মুছে ফেলতে চান?')">
                                                <i class="fas fa-trash-alt"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="8" style="text-align: center; color: #7f8c8d; font-style: italic;">কোনো আয়ের রেকর্ড পাওয়া যায়নি।</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
</body>
</html>