<?php
session_start();
// ডেটাবেস সংযোগ পাথের সঠিকতা নিশ্চিত করুন
include '../../includes/db_connection.php'; 

// নিরাপত্তা যাচাই: শুধু Admin-রাই এই পেজ অ্যাক্সেস করতে পারবে
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    die("আপনার এই পাতা ব্যবহারের অনুমতি নেই।");
}

date_default_timezone_set('Asia/Dhaka');

// বাংলা সংখ্যায় রূপান্তর ফাংশন
function format_to_bangla_number($number) {
    // সংখ্যাকে কমা-সেপারেটেড করে বাংলাতে রূপান্তর
    $formatted_number = number_format($number, 0, '.', ','); 
    $english_digits = range(0, 9);
    $bangla_digits = array('০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯');
    return str_replace($english_digits, $bangla_digits, $formatted_number);
}

// ===========================================
// ১. ফি ক্যাটেগরি (Fees) লোড করা (সংগ্রহ সহ)
// ===========================================
$fee_categories = [];
$fee_sql = "
    SELECT 
        ic.category_id, 
        ic.category_name, 
        COALESCE(SUM(f.amount), 0) AS total_collected 
    FROM 
        income_categories ic
    LEFT JOIN 
        fees f ON ic.category_id = f.category_id
    GROUP BY 
        ic.category_id, ic.category_name
    ORDER BY 
        ic.category_id ASC
";
$fee_result = $conn->query($fee_sql);

if (!$fee_result) {
    die("ফি ক্যাটেগরি লোড করতে ব্যর্থ: " . $conn->error);
}

if ($fee_result) {
    while ($row = $fee_result->fetch_assoc()) {
        $fee_categories[] = $row;
    }
}

// ===========================================
// ২. অন্যান্য আয়ের উৎস (Other Incomes) লোড করা (সংগ্রহ সহ)
// ===========================================
$other_sources = [];
$other_sql = "
    SELECT 
        isrc.source_id AS id, -- **সঠিক কলামের নাম: source_id**
        isrc.source_name, 
        isrc.is_active, 
        COALESCE(SUM(oi.amount), 0) AS total_collected 
    FROM 
        income_sources isrc
    LEFT JOIN 
        other_incomes oi ON isrc.source_name = oi.income_source
    GROUP BY 
        isrc.source_id, isrc.source_name, isrc.is_active -- **গ্রুপ বাইতেও source_id**
    ORDER BY 
        isrc.source_name ASC
";
$other_result = $conn->query($other_sql);

if (!$other_result) {
    die("অন্যান্য আয়ের উৎস লোড করতে ব্যর্থ: " . $conn->error);
}

if ($other_result) {
    while ($row = $other_result->fetch_assoc()) {
        $other_sources[] = $row;
    }
}

$conn->close();

?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>আয়ের খাতের তালিকা</title>
    <link rel="stylesheet" href="../../public/css/style.css"> 
    <style>
        .container { max-width: 1000px; margin: 50px auto; padding: 20px; background-color: #fff; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); }
        h2 { text-align: center; color: #333; margin-bottom: 20px; border-bottom: 2px solid #eee; padding-bottom: 10px; }
        .category-table { width: 100%; border-collapse: collapse; margin-bottom: 40px; }
        .category-table th, .category-table td { border: 1px solid #ddd; padding: 12px; text-align: left; }
        .category-table th { background-color: #f2f2f2; color: #333; font-weight: bold; }
        .fee-header { background-color: #4CAF50; color: white; }
        .other-header { background-color: #2196F3; color: white; }
        .amount-column { text-align: right; font-weight: bold; background-color: #e8f5e9; }
        .status-active { color: green; font-weight: bold; }
        .status-inactive { color: red; font-weight: bold; }
        .action-links a { margin-right: 15px; color: #007bff; text-decoration: none; }
        .action-links a:hover { text-decoration: underline; }
    </style>
</head>
<body>
<div class="header">
    <h1>আয়ের খাত ব্যবস্থাপনা</h1>
</div>
<div class="content">
    <div class="container">
        <h2>১. ফি সংগ্রহের খাতসমূহ</h2>
        <table class="category-table">
            <thead>
                <tr>
                    <th class="fee-header">ID</th>
                    <th class="fee-header">ফি-এর নাম</th>
                    <th class="fee-header" style="text-align: right;">মোট সংগ্রহ (৳)</th> 
                    <th class="fee-header">কার্যক্রম</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($fee_categories)): ?>
                    <?php foreach ($fee_categories as $cat): ?>
                    <tr>
                        <td><?php echo format_to_bangla_number($cat['category_id']); ?></td>
                        <td><?php echo htmlspecialchars($cat['category_name']); ?></td>
                        <td class="amount-column"><?php echo format_to_bangla_number($cat['total_collected']); ?></td> 
                        <td class="action-links">
                            <a href="/school_management/public/income/edit_fee_category.php?id=<?php echo $cat['category_id']; ?>">সম্পাদনা</a>
                            <a href="/school_management/public/income/delete_fee_category.php?id=<?php echo $cat['category_id']; ?>" onclick="return confirm('আপনি কি নিশ্চিত যে এই খাতটি মুছে ফেলতে চান?');">মুছে ফেলুন</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" style="text-align: center;">কোনো ফি-এর খাত পাওয়া যায়নি।</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>

        <h2>২. অন্যান্য আয়ের উৎসসমূহ</h2>
        <div style="text-align: right; margin-bottom: 10px;">
            <a href="/school_management/public/income/add_other_income_source.php" class="btn btn-primary" style="background-color: #2196F3; color: white; padding: 10px 15px; text-decoration: none; border-radius: 5px;">+ নতুন উৎস যোগ করুন</a>
        </div>
        <table class="category-table">
            <thead>
                <tr>
                    <th class="other-header">ID</th>
                    <th class="other-header">উৎস-এর নাম</th>
                    <th class="other-header" style="text-align: right;">মোট সংগ্রহ (৳)</th> 
                    <th class="other-header">স্ট্যাটাস</th>
                    <th class="other-header">কার্যক্রম</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($other_sources)): ?>
                    <?php foreach ($other_sources as $source): ?>
                    <tr>
                        <td><?php echo format_to_bangla_number($source['id']); ?></td>
                        <td><?php echo htmlspecialchars($source['source_name']); ?></td>
                        <td class="amount-column"><?php echo format_to_bangla_number($source['total_collected']); ?></td> 
                        <td>
                            <?php if ($source['is_active'] == 1): ?>
                                <span class="status-active">সক্রিয়</span>
                            <?php else: ?>
                                <span class="status-inactive">নিষ্ক্রিয়</span>
                            <?php endif; ?>
                        </td>
                        <td class="action-links">
                            <a href="/school_management/public/income/edit_other_income_source.php?id=<?php echo $source['id']; ?>">সম্পাদনা</a>
                            <a href="/school_management/public/income/toggle_other_income_status.php?id=<?php echo $source['id']; ?>">স্ট্যাটাস পরিবর্তন</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" style="text-align: center;">কোনো অন্যান্য আয়ের উৎস পাওয়া যায়নি।</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
</div>
</body>
</html>