<?php
session_start();
include '../../includes/db_connection.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}

if ($_SESSION['role'] !== 'Admin') {
    echo "<p style='color:red;'>এই পেজটি দেখার অনুমতি আপনার নেই।</p>";
    exit();
}

// Get the ID for 'আবাসিক ফি'
$categories_sql = "SELECT category_id, category_name FROM income_categories";
$categories_result = $conn->query($categories_sql);
$categories = [];
while ($row = $categories_result->fetch_assoc()) {
    // ক্যাটেগরি নাম key হিসেবে ব্যবহার করা হলো
    $categories[$row['category_name']] = $row['category_id']; 
}
$residential_fee_id = $categories['আবাসিক ফি'] ?? null;

// If the residential fee category doesn't exist, show an error and exit
if ($residential_fee_id === null) {
    echo "<p style='color:red;'>'আবাসিক ফি' নামে কোনো ফি-এর ধরন ডাটাবেসে পাওয়া যায়নি।</p>";
    exit();
}

$selected_year = $_GET['year'] ?? date('Y');
$selected_class_id = $_GET['class_id'] ?? '';

// Fetch fees and student details by joining fees, students, and classes tables
$fees_sql = "SELECT s.student_id, s.first_name, s.last_name, s.phone_number, c.class_name, f.amount, f.fee_month
             FROM fees f
             JOIN students s ON f.student_id = s.student_id
             LEFT JOIN classes c ON s.class_id = c.class_id
             WHERE f.category_id = ? AND YEAR(f.payment_date) = ?";

$params = [$residential_fee_id, $selected_year];
$types = 'ii';

if (!empty($selected_class_id)) {
    $fees_sql .= " AND c.class_id = ?";
    $params[] = $selected_class_id;
    $types .= 'i';
}

$fees_sql .= " ORDER BY c.class_name, s.first_name, f.fee_month"; // শ্রেণিও যোগ করা হলো

$stmt_fees = $conn->prepare($fees_sql);

// Check if the prepare statement was successful before calling bind_param
if ($stmt_fees === false) {
    echo "<p style='color:red;'>SQL কোয়েরি তৈরিতে সমস্যা: " . htmlspecialchars($conn->error) . "</p>";
    exit();
}

$stmt_fees->bind_param($types, ...$params);
$stmt_fees->execute();
$fees_result = $stmt_fees->get_result();

$students = [];
if ($fees_result) {
    while ($row = $fees_result->fetch_assoc()) {
        $student_id = $row['student_id'];
        if (!isset($students[$student_id])) {
            $students[$student_id] = [
                'first_name' => $row['first_name'],
                'last_name' => $row['last_name'],
                'phone_number' => $row['phone_number'],
                'class_name' => $row['class_name'],
                'fees' => array_fill(1, 12, 0)
            ];
        }
        $month_number = (int)date('m', strtotime($row['fee_month']));
        $students[$student_id]['fees'][$month_number] += $row['amount'];
    }
}
$stmt_fees->close();

// মাসের নাম সংক্ষিপ্ত করা হলো প্রিন্টের সুবিধার জন্য
$months = ['জানু.', 'ফেব্রু.', 'মার্চ', 'এপ্রিল', 'মে', 'জুন', 'জুলাই', 'আগস্ট', 'সেপ্টে.', 'অক্টো.', 'নভে.', 'ডিসে.'];

// ক্লাসগুলো আবার লোড করা হলো ফিল্টারের জন্য
$classes_sql = "SELECT class_id, class_name FROM classes ORDER BY class_name";
$classes_result = $conn->query($classes_sql);
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>আবাসিক ফি রিপোর্ট</title>
    <link rel="stylesheet" href="/school_management/public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Base Styles */
        .summary-table { width: 100%; border-collapse: collapse; table-layout: fixed; margin-top: 15px; }
        .summary-table th, .summary-table td { border: 1px solid #ccc; padding: 4px; font-size: 11px; text-align: center; }
        .summary-table th { background-color: #34495e; color: white; padding: 8px 4px; }
        .summary-table td:nth-child(2) { text-align: left; padding-left: 5px; font-size: 12px; } /* নাম */

        /* Header and Buttons */
        .controls { 
            display: flex; 
            justify-content: space-between; 
            align-items: flex-start; 
            margin-bottom: 20px;
        }
        .filter-group { 
            display: flex; 
            gap: 15px;
            align-items: flex-end; 
        }
        .filter-group button { 
            padding: 8px 15px; 
            background-color: #3498db; 
            color: white; 
            border: none; 
            border-radius: 4px; 
            cursor: pointer;
        }
        
        .back-button-container {
            position: absolute;
            top: 20px;
            left: 20px;
            z-index: 10;
        }
        .back-button {
            background-color: #e74c3c;
            color: white;
            padding: 8px 15px;
            border-radius: 4px;
            text-decoration: none;
            font-weight: bold;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }
        .print-button {
            background-color: #2ecc71;
            color: white;
            padding: 8px 15px;
            border-radius: 4px;
            border: none;
            cursor: pointer;
            font-weight: bold;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }
        
        /* Print Header Style (For display when printing) */
        .school-header-print {
            text-align: center;
            margin-bottom: 15px;
            display: none; /* By default hidden in browser */
        }
        .school-header-print h3 { margin: 0; font-size: 1.5em; color: #2c3e50; }
        .school-header-print p { margin: 5px 0 10px 0; font-size: 1.1em; color: #7f8c8d; }
        .school-header-print h4 { margin-top: 5px; font-size: 1.2em; color: #333; border-top: 1px solid #999; padding-top: 5px; }
        
        /* Total Summary Row (Browser View) */
        .total-summary-row {
            font-weight: bold; 
            background-color: #d1d1d1;
        }

        /* --- Print Styles --- */
        @media print {
            html, body { margin: 0; padding: 0; }
            body { background-color: white; }
            
            /* অপ্রয়োজনীয় সব উপাদান লুকানো হলো */
            .header, 
            .nav, 
            .footer, 
            .controls, 
            .container > h2,
            .back-button-container,
            .print-button { 
                display: none !important;
            }
            
            .content { padding: 0; }
            .container {
                width: 100%; 
                max-width: none !important;
                box-shadow: none !important; 
                margin: 0; 
                padding: 5mm; 
                border: none !important; 
                overflow-x: hidden;
            }

            /* স্কুলের হেডার দেখানো হলো */
            .school-header-print {
                display: block !important;
                color: #000 !important;
            }
            
            .summary-table { width: 100%; min-width: 100%; }
            .summary-table th, .summary-table td {
                font-size: 9px; 
                padding: 2px 1px;
                border: 1px solid #000;
                white-space: normal;
                word-wrap: break-word;
            }
            .summary-table th {
                background-color: #ddd !important;
                color: #000 !important;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            /* কলামের প্রস্থ অ্যাডজাস্ট করা (মোট 100%) */
            .summary-table th:nth-child(1), .summary-table td:nth-child(1) { width: 4%; } /* আইডি */
            .summary-table th:nth-child(2), .summary-table td:nth-child(2) { width: 18%; text-align: left; } /* নাম */
            .summary-table th:nth-child(3), .summary-table td:nth-child(3) { width: 8%; } /* ফোন নাম্বার */
            .summary-table th:nth-child(4), .summary-table td:nth-child(4) { width: 7%; } /* শ্রেণি */
            
            /* মোট কলাম (Last Column) */
            .summary-table th:last-child, .summary-table td:last-child { width: 6%; } 
            
            /* মাসিক কলামগুলোর জন্য বাকি প্রস্থ (100 - 4 - 18 - 8 - 7 - 6 = 57%) ১২ মাসিকের জন্য ভাগ করা হলো */
            /* 57% / 12 মাস = 4.75% প্রতি কলামে */
            <?php for ($i = 5; $i <= 16; $i++): ?>
            .summary-table th:nth-child(<?php echo $i; ?>), .summary-table td:nth-child(<?php echo $i; ?>) { **width: 4.75%;** } /* মাসিক কলামগুলো */
            <?php endfor; ?>

            .total-summary-row td {
                 font-size: 11px !important;
            }
            
            @page {
                size: legal landscape; /* ল্যান্ডস্কেপ মোড */
                margin: 0.5cm; 
            }
        }
    </style>
</head>
<body>
<div class="header">
    <h1>স্কুল ম্যানেজমেন্ট সিস্টেম</h1>
</div>
<div class="content">
    <div class="container">
        
        <div class="back-button-container">
            <a href="/school_management/public/dashboard.php" class="back-button"><i class="fas fa-arrow-left"></i> ব্যাক</a>
        </div>
        
        <div class="school-header-print">
            <h3>মিফতাহুন নাজাত মহিলা মাদরাসা</h3>
            <p>নেয়ামতপুর,সদর,নোয়াখালী।</p>
            <h4>শিক্ষার্থীদের আবাসিক ফি পরিশোধ তালিকা (<?php echo htmlspecialchars($selected_year); ?>)</h4>
        </div>

        <h2>আবাসিক ফি রিপোর্ট</h2>
        
        <div class="controls">
            <form action="" method="GET" class="filter-group">
                <div style="display: flex; flex-direction: column;">
                    <label for="year">বছর:</label>
                    <select id="year" name="year">
                        <?php for ($i = date('Y'); $i >= 2020; $i--) { echo "<option value='{$i}' " . (($i == $selected_year) ? 'selected' : '') . ">{$i}</option>"; } ?>
                    </select>
                </div>
                
                <div style="display: flex; flex-direction: column;">
                    <label for="class_id">শ্রেণি:</label>
                    <select id="class_id" name="class_id">
                        <option value="">সকল শ্রেণী</option>
                        <?php 
                        if ($classes_result && $classes_result->num_rows > 0) {
                            $classes_result->data_seek(0);
                            while($row = $classes_result->fetch_assoc()) {
                                $selected = ($selected_class_id == $row['class_id']) ? 'selected' : '';
                                echo "<option value='" . htmlspecialchars($row['class_id']) . "' $selected>" . htmlspecialchars($row['class_name']) . "</option>";
                            }
                        }
                        ?>
                    </select>
                </div>
                <button type="submit"><i class="fas fa-filter"></i> দেখুন</button>
            </form>
            <button onclick="window.print()" class="print-button"><i class="fas fa-print"></i> প্রিন্ট করুন</button>
        </div>
        
        <table class="summary-table">
            <thead>
                <tr>
                    <th rowspan="2">শিক্ষার্থী আইডি</th>
                    <th rowspan="2">নাম</th>
                    <th rowspan="2">ফোন নাম্বার</th>
                    <th rowspan="2">শ্রেণি</th>
                    <th colspan="12">আবাসিক ফি (টাকা)</th>
                    <th rowspan="2">মোট</th>
                </tr>
                <tr>
                    <?php foreach ($months as $month): ?>
                        <th><?php echo $month; ?></th>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <tbody>
                <?php 
                $grand_total = 0;
                $monthly_totals = array_fill(1, 12, 0);
                
                if (empty($students)): ?>
                    <tr><td colspan="17">কোনো আবাসিক ফি-এর তথ্য পাওয়া যায়নি।</td></tr>
                <?php else: ?>
                    <?php foreach ($students as $student_id => $student): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($student_id); ?></td>
                            <td><?php echo htmlspecialchars($student['first_name'] . ' ' . $student['last_name']); ?></td>
                            <td><?php echo htmlspecialchars($student['phone_number'] ?? '-'); ?></td>
                            <td><?php echo htmlspecialchars($student['class_name']); ?></td>
                            <?php $total_amount = 0; ?>
                            <?php for ($i = 1; $i <= 12; $i++): ?>
                                <?php 
                                    $amount = $student['fees'][$i] ?? 0; 
                                    $monthly_totals[$i] += $amount;
                                ?>
                                <td><?php echo htmlspecialchars($amount > 0 ? number_format($amount, 0) : '-'); ?></td>
                                <?php $total_amount += $amount; ?>
                            <?php endfor; ?>
                            <td><?php echo htmlspecialchars(number_format($total_amount, 0)); ?></td>
                            <?php $grand_total += $total_amount; ?>
                        </tr>
                    <?php endforeach; ?>
                    
                    <tr style="font-weight: bold; background-color: #e8e8e8;">
                        <td colspan="4" style="text-align: right; padding-right: 10px;">মাসিক ফি-এর মোট:</td>
                        <?php for ($i = 1; $i <= 12; $i++): ?>
                            <td><?php echo number_format($monthly_totals[$i], 0); ?></td>
                        <?php endfor; ?>
                        <td><?php echo number_format($grand_total, 0); ?></td>
                    </tr>
                    
                    <tr class="total-summary-row">
                        <td colspan="17" style="text-align: center; padding: 10px;">
                            সর্বমোট সংগৃহীত আবাসিক ফি: **<?php echo number_format($grand_total, 0); ?> ৳**
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
</div>
</body>
</html>