<?php
// সেশন শুরু করা
session_start();

// ডাটাবেস সংযোগ ফাইল অন্তর্ভুক্ত করা
// ধরে নেওয়া হয়েছে যে db_connection.php-এ $conn ভ্যারিয়েবলটি ডাটাবেস সংযোগ বহন করে
include '../../includes/db_connection.php';

// লগইন চেক
if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}

// অনুমতি চেক (শুধুমাত্র অ্যাডমিন)
if ($_SESSION['role'] !== 'Admin') {
    echo "<p style='color:red;'>এই পেজটি দেখার অনুমতি আপনার নেই।</p>";
    exit();
}

// Fetch income categories
$categories_sql = "SELECT category_id, category_name FROM income_categories";
$categories_result = $conn->query($categories_sql);
$categories = [];
while ($row = $categories_result->fetch_assoc()) {
    $categories[$row['category_id']] = $row['category_name'];
}

// ক্যাটেগরি নাম ও আইডি খুঁজে বের করা (নামগুলো অবশ্যই ডাটাবেসের সাথে হুবহু মিলতে হবে)
$flipped_categories = array_flip($categories);
$monthly_fee_id = $flipped_categories['মাসিক ফি'] ?? null;
$exam_fee_id = $flipped_categories['পরীক্ষার ফি'] ?? null;
$admission_fee_id = $flipped_categories['ভর্তি ফি'] ?? null;

// যদি ক্যাটেগরি আইডি না পাওয়া যায়, তবে রিপোর্ট বন্ধ করা হলো।
if (!$monthly_fee_id || !$exam_fee_id || !$admission_fee_id) {
    echo "<p style='color:red;'>গুরুত্বপূর্ণ ফি ক্যাটেগরি (মাসিক ফি, পরীক্ষার ফি, ভর্তি ফি) ডাটাবেজে খুঁজে পাওয়া যায়নি। অনুগ্রহ করে ক্যাটেগরি নামগুলো পরীক্ষা করুন।</p>";
    exit();
}

// ==========================================
// ১. ফিল্টার প্যারামিটার গ্রহণ
// ==========================================
$selected_year = $_GET['year'] ?? date('Y');
$selected_class_id = $_GET['class_id'] ?? '';
$search_query = $_GET['search'] ?? ''; // নতুন সার্চ প্যারামিটার

// Fetch classes for filter
$classes_sql = "SELECT class_id, class_name FROM classes ORDER BY class_name";
$classes_result = $conn->query($classes_sql);

// ==========================================
// ২. সার্চ ও ক্লাস ফিল্টার সহ শিক্ষার্থী ডেটা আনা
// ==========================================
$students_sql = "SELECT s.student_id, s.first_name, s.last_name, c.class_name 
                 FROM students s
                 LEFT JOIN classes c ON s.class_id = c.class_id";

$where_clauses = [];
$params = [];
$param_types = '';

// ক্লাস ফিল্টার লজিক
if (!empty($selected_class_id)) {
    $where_clauses[] = "s.class_id = ?";
    $params[] = $selected_class_id;
    $param_types .= 'i';
}

// সার্চ ফিল্টার লজিক
if (!empty($search_query)) {
    $search_term = "%" . $search_query . "%";
    // আইডি, প্রথম নাম বা শেষ নাম দ্বারা সার্চ
    $where_clauses[] = " (s.student_id = ? OR s.first_name LIKE ? OR s.last_name LIKE ?) ";
    
    // আইডির জন্য সংখ্যা, নামের জন্য স্ট্রিং
    $params[] = is_numeric($search_query) ? (int)$search_query : 0; 
    $params[] = $search_term;
    $params[] = $search_term;
    $param_types .= 'iss'; 
}

if (!empty($where_clauses)) {
    $students_sql .= " WHERE " . implode(" AND ", $where_clauses);
}

$students_sql .= " ORDER BY c.class_name, s.first_name";

$stmt = $conn->prepare($students_sql);

// ডায়নামিক প্যারামিটার বাইন্ডিং
if (!empty($params)) { 
    $stmt->bind_param($param_types, ...$params); 
}

$stmt->execute();
$students_result = $stmt->get_result();
$students = [];
if ($students_result) {
    while ($row = $students_result->fetch_assoc()) {
        $students[$row['student_id']] = $row;
    }
}
$stmt->close();

// ==========================================
// ৩. ফি ডেটা আনা (অপরিবর্তিত)
// ==========================================
$fees = [];
$fees_sql = "SELECT f.student_id, f.amount, f.fee_month, f.category_id
             FROM fees f
             WHERE YEAR(f.payment_date) = ? AND f.category_id IN (?, ?, ?) 
             AND f.student_id IN (";

// কেবল মাত্র ফিল্টার করা শিক্ষার্থীদের ফি আনা
$student_ids = array_keys($students);
if (empty($student_ids)) {
    $fees_sql .= "0"; // যদি কোনো শিক্ষার্থী না থাকে
} else {
    // ডাইনামিক প্লেসহোল্ডার তৈরি
    $placeholders = implode(',', array_fill(0, count($student_ids), '?'));
    $fees_sql .= $placeholders;
}
$fees_sql .= ")";

$stmt_fees = $conn->prepare($fees_sql);

// প্যারামিটার বাইন্ডিং তৈরি
$fee_bind_params = "iiii" . str_repeat('i', count($student_ids));
$fee_bind_values = array_merge([$selected_year, $monthly_fee_id, $exam_fee_id, $admission_fee_id], $student_ids);

// বাইন্ডিং
if (!empty($student_ids)) {
    $stmt_fees->bind_param($fee_bind_params, ...$fee_bind_values);
    $stmt_fees->execute();
    $fees_result = $stmt_fees->get_result();
} else {
    $fees_result = false;
}


if ($fees_result) {
    while ($row = $fees_result->fetch_assoc()) {
        $student_id = $row['student_id'];
        $category_id = $row['category_id'];
        
        if (!isset($fees[$student_id])) { 
            $fees[$student_id] = ['monthly' => array_fill(1, 12, 0), 'exam' => 0, 'admission' => 0]; 
        }
        
        if ($category_id == $monthly_fee_id) {
            $month_number = (int)date('m', strtotime($row['fee_month']));
            $fees[$student_id]['monthly'][$month_number] += $row['amount'];
        } elseif ($category_id == $exam_fee_id) {
            $fees[$student_id]['exam'] += $row['amount'];
        } elseif ($category_id == $admission_fee_id) {
            $fees[$student_id]['admission'] += $row['amount'];
        }
    }
}
$stmt_fees->close();
$conn->close(); // ডাটাবেস সংযোগ বন্ধ করা হলো

// প্রিন্টের জন্য সংক্ষিপ্ত মাস নাম ব্যবহার করা হলো
$months = ['জানু.', 'ফেব্রু.', 'মার্চ', 'এপ্রিল', 'মে', 'জুন', 'জুলাই', 'আগস্ট', 'সেপ্টে.', 'অক্টো.', 'নভে.', 'ডিসে.']; 
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>মাসিক ও অন্যান্য ফি রিপোর্ট</title>
    <link rel="stylesheet" href="/school_management/public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* Base Styles */
        .summary-table { width: 100%; border-collapse: collapse; table-layout: fixed; margin-top: 15px; }
        .summary-table th, .summary-table td { border: 1px solid #ccc; padding: 4px; font-size: 11px; text-align: center; }
        .summary-table th { background-color: #34495e; color: white; padding: 8px 4px; }
        .summary-table td:nth-child(2) { text-align: left; padding-left: 5px; font-size: 12px; } /* নাম */

        /* Header and Controls */
        .controls { display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 20px; flex-wrap: wrap; }
        .filter-group { display: flex; gap: 10px; align-items: flex-end; flex-wrap: wrap; } 
        .filter-item { display: flex; flex-direction: column; }
        .filter-item label { font-weight: bold; font-size: 12px; margin-bottom: 2px; }
        .filter-item select, .filter-item input[type="text"], .filter-item button { 
            padding: 6px 10px; 
            border: 1px solid #ccc; 
            border-radius: 4px; 
            font-size: 14px; 
        }

        .back-button, .print-button {
            background-color: #e74c3c;
            color: white;
            padding: 8px 15px;
            border-radius: 4px;
            text-decoration: none;
            font-weight: bold;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            border: none;
            cursor: pointer;
        }
        .print-button { background-color: #2ecc71; }
        .reset-button { background-color: #f39c12; color: white; border: none; }
        
        .total-summary-row {
            font-weight: bold; 
            background-color: #d1d1d1;
        }

        /* --- Print Styles --- */
        @media print {
            /* অপ্রয়োজনীয় সব উপাদান লুকানো হলো */
            .header, .nav, .footer, .controls, .container > h2, .back-button-container, .print-button { 
                display: none !important;
            }
            .container {
                width: 100%; max-width: none !important; box-shadow: none !important; margin: 0; padding: 5mm; border: none !important; overflow-x: hidden;
            }
            .school-header-print {
                display: block !important; color: #000 !important;
            }
            .summary-table { width: 100%; min-width: 100%; }
            .summary-table th, .summary-table td {
                font-size: 9px; padding: 2px 1px; border: 1px solid #000; white-space: normal; word-wrap: break-word;
            }
            .summary-table th {
                background-color: #ddd !important; color: #000 !important; -webkit-print-color-adjust: exact; print-color-adjust: exact;
            }
            
            /* নতুন কলামের প্রস্থ অ্যাডজাস্ট করা: 
            শিক্ষার্থী আইডি: 4%
            নাম: 13%
            শ্রেণি: 4%
            মোট হেডার: 21%
            বাকি 14টি ডাটা কলামের জন্য: 79% (প্রতিটি 5.64% বা 5.68%) */
            
            .summary-table th:nth-child(1), .summary-table td:nth-child(1) { width: 4%; }  /* শিক্ষার্থী আইডি */
            .summary-table th:nth-child(2), .summary-table td:nth-child(2) { width: 13%; text-align: left; } /* নাম */
            .summary-table th:nth-child(3), .summary-table td:nth-child(3) { width: 4%; }  /* শ্রেণি */
            
            /* মাসিক ফি (12 মাস) এবং পরীক্ষার ফি (1) = 13টি কলামে 5.64% */
            <?php for ($i = 4; $i <= 16; $i++): ?>
            .summary-table th:nth-child(<?php echo $i; ?>), .summary-table td:nth-child(<?php echo $i; ?>) { 
                width: 5.64%; 
            } 
            <?php endfor; ?>

            /* ভর্তি ফি (17) - 5.68% (মোট 100% নিশ্চিত করতে সামান্য বাড়ানো হলো) */
            .summary-table th:nth-child(17), .summary-table td:nth-child(17) { width: 5.68%; } /* ভর্তি ফি */
            
            
            .total-summary-row td { font-size: 11px !important; }
            @page { size: legal landscape; margin: 0.5cm; }
        }
    </style>
</head>
<body>
<div class="header">
    <h1>স্কুল ম্যানেজমেন্ট সিস্টেম</h1>
</div>
<div class="content">
    <div class="container">
        
        <div class="back-button-container">
            <a href="/school_management/public/dashboard.php" class="back-button"><i class="fas fa-arrow-left"></i> ব্যাক</a>
        </div>
        
        <div class="school-header-print">
            <h3>মিফতাহুন নাজাত মহিলা মাদরাসা</h3>
            <p>নেয়ামতপুর,সদর,নোয়াখালী।</p>
            <h4>মাসিক শিক্ষার্থীর বেতন পরিশোধ তালিকা (<?php echo htmlspecialchars($selected_year); ?>)</h4>
        </div>

        <h2>মাসিক, পরীক্ষার ও ভর্তি ফি রিপোর্ট</h2>
        
        <div class="controls">
            <form action="" method="GET" class="filter-group">
                <div class="filter-item">
                    <label for="year">বছর:</label>
                    <select id="year" name="year">
                        <?php for ($i = date('Y'); $i >= 2020; $i--) { echo "<option value='{$i}' " . (($i == $selected_year) ? 'selected' : '') . ">{$i}</option>"; } ?>
                    </select>
                </div>
                
                <div class="filter-item">
                    <label for="class_id">শ্রেণি:</label>
                    <select id="class_id" name="class_id">
                        <option value="">--সকল শ্রেণি--</option>
                        <?php 
                        if ($classes_result) {
                             $classes_result->data_seek(0);
                             while ($row = $classes_result->fetch_assoc()) { 
                                 echo "<option value='{$row['class_id']}' " . (($row['class_id'] == $selected_class_id) ? 'selected' : '') . ">{$row['class_name']}</option>"; 
                             } 
                        }
                        ?>
                    </select>
                </div>

                <div class="filter-item" style="flex-grow: 1;">
                    <label for="search">নাম/আইডি দিয়ে খুঁজুন:</label>
                    <input 
                        type="text" 
                        id="search" 
                        name="search" 
                        value="<?php echo htmlspecialchars($search_query); ?>" 
                        placeholder="নাম, আইডি..."
                        style="min-width: 200px;"
                    >
                </div>

                <div class="filter-item" style="margin-top: auto;">
                    <button type="submit" style="background-color: #3498db; color: white;">ফিল্টার করুন</button>
                </div>
                
                <?php if (!empty($selected_class_id) || !empty($search_query)): ?>
                    <div class="filter-item" style="margin-top: auto;">
                        <a href="?year=<?php echo htmlspecialchars($selected_year); ?>" class="button reset-button">ফিল্টার মুছুন</a>
                    </div>
                <?php endif; ?>

            </form>
            <button onclick="window.print()" class="print-button"><i class="fas fa-print"></i> প্রিন্ট করুন</button>
        </div>
        
        <?php if (empty($students)): ?>
            <p style='color:red; text-align: center; padding: 20px; border: 1px solid #f8d7da; background-color: #f8d7da;'>
                <?php echo (!empty($search_query) || !empty($selected_class_id)) ? 'আপনার সার্চ/ফিল্টারের সাথে কোনো শিক্ষার্থী পাওয়া যায়নি।' : 'এই বছরে কোনো শিক্ষার্থী পাওয়া যায়নি।'; ?>
            </p>
        <?php else: ?>
            <table class="summary-table">
                <thead>
                    <tr>
                        <th rowspan="2">শিক্ষার্থী আইডি</th>
                        <th rowspan="2">নাম</th>
                        <th rowspan="2">শ্রেণি</th>
                        <th colspan="12">মাসিক ফি (টাকা)</th>
                        <th rowspan="2">পরীক্ষার ফি</th>
                        <th rowspan="2">ভর্তি ফি</th>
                    </tr>
                    <tr>
                        <?php foreach ($months as $month): ?>
                            <th><?php echo $month; ?></th>
                        <?php endforeach; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $grand_total_monthly = 0;
                    $grand_total_exam = 0;
                    $grand_total_admission = 0;
                    $monthly_totals = array_fill(1, 12, 0);

                    foreach ($students as $student_id => $student): 
                        $student_exam_fee = $fees[$student_id]['exam'] ?? 0;
                        $student_admission_fee = $fees[$student_id]['admission'] ?? 0;
                    ?>
                        <tr>
                            <td><?php echo htmlspecialchars($student_id); ?></td>
                            <td><?php echo htmlspecialchars($student['first_name'] . ' ' . $student['last_name']); ?></td>
                            <td><?php echo htmlspecialchars($student['class_name']); ?></td>
                            
                            <?php for ($i = 1; $i <= 12; $i++): 
                                $monthly_fee = $fees[$student_id]['monthly'][$i] ?? 0;
                                $monthly_display = ($monthly_fee > 0) ? number_format($monthly_fee, 0) : '-';
                                $monthly_totals[$i] += $monthly_fee;
                            ?>
                                <td><?php echo $monthly_display; ?></td>
                            <?php endfor; ?>
                            
                            <td><?php echo ($student_exam_fee > 0) ? number_format($student_exam_fee, 0) : '-'; ?></td>
                            <td><?php echo ($student_admission_fee > 0) ? number_format($student_admission_fee, 0) : '-'; ?></td>
                        </tr>
                    <?php 
                        $grand_total_exam += $student_exam_fee;
                        $grand_total_admission += $student_admission_fee;
                    endforeach; 
                    
                    $grand_total_monthly = array_sum($monthly_totals);
                    $grand_total = $grand_total_monthly + $grand_total_exam + $grand_total_admission;
                    ?>
                    
                    <tr style="font-weight: bold; background-color: #e8e8e8;">
                        <td colspan="3" style="text-align: right; padding-right: 10px;">মাসিক ফি-এর মোট:</td>
                        <?php for ($i = 1; $i <= 12; $i++): ?>
                            <td><?php echo number_format($monthly_totals[$i], 0); ?></td>
                        <?php endfor; ?>
                        <td><?php echo number_format($grand_total_exam, 0); ?></td>
                        <td><?php echo number_format($grand_total_admission, 0); ?></td>
                    </tr>

                    <tr class="total-summary-row">
                        <td colspan="17" style="text-align: center; padding: 10px; background-color: #d4edda; color: #155724;">
                            মাসিক ফি (মোট): **<?php echo number_format($grand_total_monthly, 0); ?> ৳** | 
                            পরীক্ষার ফি (মোট): **<?php echo number_format($grand_total_exam, 0); ?> ৳** | 
                            ভর্তি ফি (মোট): **<?php echo number_format($grand_total_admission, 0); ?> ৳** <br>
                            সর্বমোট সংগৃহীত ফি: **<?php echo number_format($grand_total, 0); ?> ৳**
                        </td>
                    </tr>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>
<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
</div>
</body>
</html>
