<?php
// get_student_details.php

session_start();
// আপনার ডাটাবেস সংযোগ ফাইলটি সঠিকভাবে অন্তর্ভুক্ত করুন
include '../../includes/db_connection.php'; 

header('Content-Type: application/json');

// শুধুমাত্র GET অনুরোধ এবং student_id সেট করা আছে কিনা পরীক্ষা করা
if ($_SERVER["REQUEST_METHOD"] !== "GET" || !isset($_GET['student_id']) || empty($_GET['student_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid Request or Student ID']);
    exit();
}

$student_id = $_GET['student_id'];

// SQL ক্যোয়ারি: আপনার টেবিলের কলাম নামগুলো ব্যবহার করা হয়েছে
$sql = "SELECT 
            s.student_id, s.first_name, s.last_name, s.class_roll, s.date_of_birth, 
            s.father_name, s.mother_name, s.phone_number, s.enrollment_date,
            c.class_name 
        FROM students s
        JOIN classes c ON s.class_id = c.class_id
        WHERE s.student_id = ?";

$stmt = $conn->prepare($sql);

if ($stmt === false) {
    // ডিবাগিং এর জন্য SQL এরর দেখানো
    error_log("SQL Prepare Error: " . $conn->error);
    echo json_encode(['status' => 'error', 'message' => 'Internal SQL Error']);
    exit();
}

$stmt->bind_param("s", $student_id);

if (!$stmt->execute()) {
    error_log("SQL Execute Error: " . $stmt->error);
    echo json_encode(['status' => 'error', 'message' => 'Database Execution Error']);
    exit();
}

$result = $stmt->get_result();
$data = $result->fetch_assoc();
$stmt->close();
$conn->close();

if ($data) {
    // ডেটা বিন্যাস করা:
    $data['student_name'] = $data['first_name'] . ' ' . $data['last_name'];
    
    // JS এ ব্যবহারের জন্য কী-গুলো ঠিক করা হলো
    $data['dob'] = $data['date_of_birth'] ? date('d-m-Y', strtotime($data['date_of_birth'])) : 'N/A';
    $data['admission_date'] = $data['enrollment_date'] ? date('d-m-Y', strtotime($data['enrollment_date'])) : 'N/A';
    
    // অপ্রয়োজনীয় কলামগুলো সরিয়ে ফেলা
    unset($data['first_name'], $data['last_name'], $data['date_of_birth'], $data['enrollment_date']); 
    
    echo json_encode(['status' => 'success', 'data' => $data]);
} else {
    // এই মেসেজটিই JavaScript এ 'শিক্ষার্থীর তথ্য খুঁজে পাওয়া যায়নি' ত্রুটি হিসেবে দেখাবে
    echo json_encode(['status' => 'error', 'message' => 'No student data found']);
}
?>