<?php
session_start();
include '../../includes/db_connection.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}

$message = '';
$error = '';

// Fetch category IDs
$categories_sql = "SELECT category_id, category_name FROM income_categories";
$categories_result = $conn->query($categories_sql);
$categories = [];
while ($row = $categories_result->fetch_assoc()) {
    $categories[$row['category_name']] = $row['category_id'];
}
$monthly_fee_id = $categories['মাসিক ফি'] ?? null;
$exam_fee_id = $categories['পরীক্ষার ফি'] ?? null;
$admission_fee_id = $categories['ভর্তি ফি'] ?? null;

// Handle delete action
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['delete_payment_id'])) {
    if ($_SESSION['role'] === 'Admin' || $_SESSION['role'] === 'Accountant') {
        $payment_id = $_POST['delete_payment_id'];
        
        $sql = "DELETE FROM fees WHERE payment_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $payment_id);
        
        if ($stmt->execute()) {
            $message = "ফি সফলভাবে মুছে ফেলা হয়েছে!";
        } else {
            $error = "ফি মোছার সময় সমস্যা হয়েছে: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $error = "মুছে ফেলার অনুমতি নেই।";
    }
}

// Fetch all classes for the filter dropdown
$classes_sql = "SELECT class_id, class_name FROM classes ORDER BY class_name";
$classes_result = $conn->query($classes_sql);

// SQL ক্যোয়ারিতে student_id এবং memo_no নির্বাচন করা হয়েছে
$report_sql = "SELECT f.payment_id, f.student_id, f.payment_method, f.memo_no, s.first_name, s.last_name, s.class_roll, c.class_name, f.amount, f.payment_date, f.fee_month, ic.category_name
              FROM fees f
              JOIN students s ON f.student_id = s.student_id
              JOIN classes c ON s.class_id = c.class_id
              JOIN income_categories ic ON f.category_id = ic.category_id
              WHERE 1=1";

$params = [];
$types = '';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['filter_report'])) {
    if (!empty($_POST['class_id'])) {
        $report_sql .= " AND c.class_id = ?";
        $params[] = $_POST['class_id'];
        $types .= 'i';
    }
    
    if (!empty($_POST['start_date'])) {
        $report_sql .= " AND f.payment_date >= ?";
        $params[] = $_POST['start_date'];
        $types .= 's';
    }
    if (!empty($_POST['end_date'])) {
        $report_sql .= " AND f.payment_date <= ?";
        $params[] = $_POST['end_date'];
        $types .= 's';
    }
    
    if (!empty($_POST['fee_month'])) {
        $report_sql .= " AND f.fee_month = ?";
        $params[] = $_POST['fee_month'];
        $types .= 's';
    }
}

$report_sql .= " ORDER BY c.class_name, s.class_roll, f.payment_date DESC";

$stmt = $conn->prepare($report_sql);

if ($stmt === false) {
    $error = "SQL কোয়েরি তৈরিতে সমস্যা: " . $conn->error;
    $report_result = false;
} else {
    if (!empty($params)) {
        $stmt->bind_param($types, ...$params);
    }
    
    if (!$stmt->execute()) {
        $error = "রিপোর্ট তৈরিতে সমস্যা: " . $stmt->error;
        $report_result = false;
    } else {
        $report_result = $stmt->get_result();
    }
    $stmt->close();
}

$months = [
    '01' => 'জানুয়ারি', '02' => 'ফেব্রুয়ারি', '03' => 'মার্চ',
    '04' => 'এপ্রিল', '05' => 'মে', '06' => 'জুন',
    '07' => 'জুলাই', '08' => 'আগস্ট', '09' => 'সেপ্টেম্বর',
    '10' => 'অক্টোবর', '11' => 'নভেম্বর', '12' => 'ডিসেম্বর'
];
$currentYear = date('Y');
$years = range($currentYear, $currentYear - 5);
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ফি রিপোর্ট</title>
    <link rel="stylesheet" href="/school_management/public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .report-form {
            background-color: #f2f2f2;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: flex;
            gap: 15px;
            align-items: flex-end;
            flex-wrap: wrap; 
        }
        .report-form .form-group {
            flex: 1;
            min-width: 150px; 
            display: flex;
            flex-direction: column;
        }
        .report-form label {
            margin-bottom: 5px;
            font-weight: bold;
        }
        .report-form select, .report-form input:not([type="hidden"]), .report-form button {
            padding: 8px;
            border-radius: 4px;
            border: 1px solid #ccc;
        }
        .report-form button {
            background-color: #28a745;
            color: white;
            cursor: pointer;
            border: none;
            flex-shrink: 0;
            height: 38px; 
        }
        .report-form button:hover {
            background-color: #218838;
        }
        .report-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .report-table th, .report-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            font-size: 14px;
        }
        .report-table th {
            background-color: #34495e;
            color: white;
            text-align: center;
        }
        .report-table td {
            text-align: center;
        }
        .report-table td:nth-child(2), /* শিক্ষার্থীর নাম */
        .report-table td:nth-child(6) /* ফি-এর ধরন */
        {
            text-align: left;
        }
        
        /* Action Icons Styling */
        .actions {
            white-space: nowrap; 
            width: 1%; 
            text-align: center !important;
        }
        .actions a, .actions button {
            display: inline-block;
            padding: 6px 8px;
            border-radius: 4px;
            margin: 0 2px;
            color: white;
            font-size: 14px;
            border: none;
            cursor: pointer;
            text-decoration: none;
            line-height: 1;
        }
        .actions .edit-btn { background-color: #007bff; }
        .actions .receipt-btn { background-color: #6c757d; }
        .actions .delete-btn { background-color: #dc3545; }

        /* Print Header Style */
        .school-header-print {
            text-align: center;
            margin-bottom: 20px;
            display: none; 
        }
        .school-header-print h3 {
            margin: 0;
            color: #2c3e50;
        }
        .school-header-print p {
            margin: 0;
            font-size: 1.1em;
            color: #7f8c8d;
        }
        
        /* Back Button Style */
        .back-button-container {
            position: absolute;
            top: 20px;
            left: 20px;
        }
        .back-button-container a {
            background-color: #3498db;
            color: white;
            padding: 8px 15px;
            border-radius: 4px;
            text-decoration: none;
            font-weight: bold;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }

        /* Print Button next to Filter Form */
        .print-button {
            background-color: #3498db;
            color: white;
            padding: 8px 15px;
            border-radius: 4px;
            border: none;
            cursor: pointer;
            font-weight: bold;
            margin-left: 10px;
            flex-shrink: 0;
            height: 38px;
        }

        /* --- পপআপের জন্য গুরুত্বপূর্ণ স্টাইল --- */
        .popup-overlay {
            display: none; /* ডিফল্টভাবে লুকিয়ে রাখা */
            position: fixed; /* স্ক্রিনের সাপেক্ষে অবস্থান */
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5); /* স্বচ্ছ কালো পটভূমি */
            justify-content: center; /* পপআপকে কেন্দ্রে আনা */
            align-items: center;
            z-index: 1000; /* নিশ্চিত করা যেন অন্য উপাদানের উপরে থাকে */
        }
        .receipt-box {
            background-color: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            max-width: 400px;
            width: 90%;
            text-align: left;
            position: relative;
        }
        .receipt-details p, #student-details-content p {
             margin: 5px 0;
        }
        .receipt-details strong, #student-details-content strong {
            display: inline-block;
            width: 120px; /* লেবেলগুলোর জন্য নির্দিষ্ট প্রস্থ */
        }
        .receipt-buttons, #student-details-overlay .receipt-buttons {
            margin-top: 20px;
            text-align: right;
        }
        #student-details-overlay .receipt-box {
            max-width: 500px; /* শিক্ষার্থীর তথ্যের জন্য একটু বড় পপআপ */
        }
        /* শিক্ষার্থীর আইডির জন্য স্টাইল যাতে ক্লিক করা হয়েছে বোঝা যায় */
        .student-id-link { 
            cursor: pointer; 
            color: #007bff; 
            font-weight: bold;
            text-decoration: underline; /* লিংক হিসাবে চিহ্নিত করতে */
        }
        /* --- পপআপের জন্য গুরুত্বপূর্ণ স্টাইল শেষ --- */

        /* --- Print Styles --- */
        @media print {
            /* পুরো পেজের মার্জিন শূন্য করা হলো */
            html, body {
                margin: 0;
                padding: 0;
            }
            body {
                background-color: white;
            }
            /* অপ্রয়োজনীয় সব উপাদান লুকানো হলো */
            .header, 
            .nav, 
            .footer, 
            .report-form, 
            .actions, /* অ্যাকশন কলাম ও বাটন লুকানো হলো */
            .container > h2, /* মূল শিরোনাম লুকানো হলো */
            .back-button-container,
            .print-button { 
                display: none !important;
            }
            
            /* শুধু রসিদ প্রিন্ট করার সময় এই স্টাইলটি ব্যবহার হবে */
            .popup-overlay, #student-details-overlay {
                display: none !important;
            }

            /* যখন window.print() কল করা হয় তখন শুধু টেবিল দেখানোর জন্য */
            .container {
                width: 100%; 
                max-width: none !important;
                box-shadow: none !important; 
                margin: 0; 
                padding: 10mm;
                border: none !important; 
            }
            .report-table {
                 width: 100%; 
            }
            .report-table td, .report-table th {
                font-size: 11px;
                padding: 5px;
                border: 1px solid #000;
            }
            /* প্রিন্টের সময় স্কুলের হেডার দেখানো হলো */
            .school-header-print {
                display: block !important;
                margin-bottom: 15px !important;
                width: 100%;
                color: #000 !important;
            }
            .school-header-print p {
                color: #000 !important;
            }
            .school-header-print h3:last-of-type { 
                margin-top: 10px;
                border-top: 1px solid #000;
                padding-top: 5px;
                font-size: 1.3em;
            }

            @page {
                size: A4 portrait; 
                margin: 0.5cm; 
            }
        }
    </style>
</head>
<body>
<div class="header">
    <div class="back-button-container">
        <a href="/school_management/public/dashboard.php"><i class="fas fa-arrow-left"></i> ব্যাক</a>
    </div>
    <h1>স্কুল ম্যানেজমেন্ট সিস্টেম</h1>
    <div class="nav">
        <a href="/school_management/public/dashboard.php">ড্যাশবোর্ড</a>
        <a href="/school_management/public/students/students_list.php">শিক্ষার্থী</a>
        <a href="/school_management/public/teachers/teachers_list.php">শিক্ষক</a>
        <a href="/school_management/public/fees/fee_collection.php">ফি সংগ্রহ</a>
        <a href="/school_management/public/subjects/subjects_list.php">বিষয়সমূহ</a>
        <a href="/school_management/public/exam_results/add_exam_result.php">পরীক্ষা</a>
        <a href="/school_management/public/attendance/record_attendance.php">উপস্থিতি</a>
        <a href="/school_management/public/change_password.php">পাসওয়ার্ড পরিবর্তন</a>
        <a href="/school_management/public/logout.php">লগআউট</a>
    </div>
</div>
<div class="content">
    <div class="container">
        
        <div class="school-header-print">
            <h3>মিফতাহুন নাজাত মহিলা মাদরাসা</h3>
            <p>নেয়ামতপুর,সদর,নোয়াখালী।</p>
            <h3>ফি কালেকশন রিপোর্ট</h3>
        </div>
        
        <h2>ফি রিপোর্ট</h2>
        
        <?php if ($message): ?>
            <p style='color:green;'><?php echo $message; ?></p>
        <?php endif; ?>
        <?php if ($error): ?>
            <p style='color:red;'><?php echo $error; ?></p>
        <?php endif; ?>

        <div style="display: flex; justify-content: space-between; align-items: flex-end; flex-wrap: wrap;">
            <form method="POST" action="" class="report-form" style="margin-bottom: 0; flex-grow: 1; flex-basis: 80%;">
                <input type="hidden" name="filter_report" value="1">
                
                <div class="form-group">
                    <label for="class_id">শ্রেণি নির্বাচন করুন:</label>
                    <select id="class_id" name="class_id">
                        <option value="">সকল শ্রেণি</option>
                        <?php 
                        if ($classes_result && $classes_result->num_rows > 0) {
                            $classes_result->data_seek(0);
                            while($row = $classes_result->fetch_assoc()) {
                                $selected = (isset($_POST['class_id']) && $_POST['class_id'] == $row['class_id']) ? 'selected' : '';
                                echo "<option value='" . htmlspecialchars($row['class_id']) . "' $selected>" . htmlspecialchars($row['class_name']) . "</option>";
                            }
                        }
                        ?>
                    </select>
                </div>
                
                <div class="form-group">
                    <label for="start_date">শুরুর তারিখ:</label>
                    <input type="date" id="start_date" name="start_date" value="<?php echo htmlspecialchars($_POST['start_date'] ?? ''); ?>">
                </div>
                
                <div class="form-group">
                    <label for="end_date">শেষের তারিখ:</label>
                    <input type="date" id="end_date" name="end_date" value="<?php echo htmlspecialchars($_POST['end_date'] ?? ''); ?>">
                </div>
                
                <div class="form-group">
                    <label for="fee_month">মাস নির্বাচন করুন:</label>
                    <select id="fee_month" name="fee_month">
                        <option value="">সকল মাস</option>
                        <?php 
                            foreach ($years as $year) {
                                foreach ($months as $num => $name) {
                                    $fullMonth = $year . '-' . $num;
                                    $selected = (isset($_POST['fee_month']) && $_POST['fee_month'] == $fullMonth) ? 'selected' : '';
                                    echo "<option value='". htmlspecialchars($fullMonth) . "' $selected>" . htmlspecialchars($name) . " " . htmlspecialchars($year) . "</option>";
                                }
                            }
                        ?>
                    </select>
                </div>
                <button type="submit">রিপোর্ট দেখুন</button>
            </form>
            <button onclick="window.print()" class="print-button"><i class="fas fa-print"></i> প্রিন্ট</button>
        </div>

        <?php if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['filter_report']) && $report_result !== false): ?>
            <table class="report-table">
                <thead>
                    <tr>
                        <th style="width: 8%;">শিক্ষার্থীর আইডি</th>
                        <th style="width: 17%;">শিক্ষার্থীর নাম</th>
                        <th style="width: 6%;">রোল</th>
                        <th style="width: 8%;">শ্রেণি</th>
                        <th style="width: 10%;">মেমো নং</th> 
                        <th style="width: 12%;">ফি-এর ধরন</th>
                        <th style="width: 9%;">জমা করা ফি</th>
                        <th style="width: 10%;">মাস</th>
                        <th style="width: 10%;">জমা দেওয়ার তারিখ</th>
                        <th style="width: 10%;">অ্যাকশন</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $total_collected_fee = 0;
                    if ($report_result->num_rows > 0): 
                    ?>
                        <?php while($row = $report_result->fetch_assoc()): 
                            $total_collected_fee += $row['amount'];
                        ?>
                            <tr>
                                <td class="student-id-link" onclick="showStudentDetails('<?php echo htmlspecialchars($row['student_id']); ?>')">
                                    <?php echo htmlspecialchars($row['student_id']); ?>
                                </td>
                                <td style="text-align: left;"><?php echo htmlspecialchars($row['first_name'] . ' ' . $row['last_name']); ?></td>
                                <td><?php echo htmlspecialchars($row['class_roll']); ?></td>
                                <td><?php echo htmlspecialchars($row['class_name']); ?></td>
                                <td><?php echo htmlspecialchars($row['memo_no'] ?? '-'); ?></td>
                                <td style="text-align: left;"><?php echo htmlspecialchars($row['category_name']); ?></td>
                                <td><?php echo htmlspecialchars(number_format($row['amount'], 0)); ?> ৳</td>
                                <td><?php echo htmlspecialchars($row['fee_month'] ? $months[substr($row['fee_month'], 5, 2)] . ' ' . substr($row['fee_month'], 0, 4) : '-'); ?></td>
                                <td><?php echo htmlspecialchars(date('d-m-Y', strtotime($row['payment_date']))); ?></td>
                                <td class="actions">
                                    <a href="edit_fee.php?id=<?php echo htmlspecialchars($row['payment_id']); ?>" class="edit-btn" title="সম্পাদনা"><i class="fas fa-edit"></i></a>
                                    <button onclick="showReceipt(<?php echo $row['payment_id']; ?>)" class="receipt-btn" title="রসিদ"><i class="fas fa-receipt"></i></button>
                                    <?php if ($_SESSION['role'] === 'Admin' || $_SESSION['role'] === 'Accountant'): ?>
                                        <form method="POST" action="" style="display:inline-block;">
                                            <input type="hidden" name="delete_payment_id" value="<?php echo htmlspecialchars($row['payment_id']); ?>">
                                            <button type="submit" class="delete-btn" title="মুছুন" onclick="return confirm('আপনি কি নিশ্চিত যে এই ফি রেকর্ডটি মুছে ফেলতে চান?')"><i class="fas fa-trash-alt"></i></button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                        <tr>
                            <td colspan="6" style="text-align: right; font-weight: bold;">মোট সংগৃহীত ফি:</td>
                            <td style="font-weight: bold;"><?php echo htmlspecialchars(number_format($total_collected_fee, 0)); ?> ৳</td>
                            <td colspan="3"></td>
                        </tr>
                    <?php else: ?>
                        <tr>
                            <td colspan="10">কোনো ফি রেকর্ড পাওয়া যায়নি।</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<div id="student-details-overlay" class="popup-overlay">
    <div class="receipt-box" style="max-width: 500px;">
        <div class="receipt-header">
            <h3 id="student-popup-name">শিক্ষার্থীর বিস্তারিত তথ্য</h3>
        </div>
        <div class="receipt-details" id="student-details-content">
            <p><strong>শিক্ষার্থী আইডি:</strong> <span id="s-id"></span></p>
            <p><strong>শিক্ষার্থীর নাম:</strong> <span id="s-name"></span></p>
            <p><strong>শ্রেণি:</strong> <span id="s-class"></span></p>
            <p><strong>রোল নং:</strong> <span id="s-roll"></span></p>
            <p><strong>জন্ম তারিখ:</strong> <span id="s-dob"></span></p>
            <p><strong>পিতার নাম:</strong> <span id="s-father"></span></p>
            <p><strong>মাতার নাম:</strong> <span id="s-mother"></span></p>
            <p><strong>যোগাযোগ:</strong> <span id="s-phone"></span></p>
            <p><strong>ভর্তির তারিখ:</strong> <span id="s-admission-date"></span></p>
        </div>
        <div class="receipt-buttons">
            <button id="closeStudentBtn"><i class="fas fa-times"></i> বন্ধ করুন</button>
        </div>
    </div>
</div>
<div id="receipt-popup-overlay" class="popup-overlay">
    <div class="receipt-box">
        <div class="receipt-header">
            <h3>ফি জমার রসিদ</h3>
            <p>মিফতাহুন নাজাত মহিলা মাদরাসা</p>
        </div>
        <div class="receipt-details">
            <p><strong>শিক্ষার্থীর আইডি:</strong> <span id="receipt-student-id"></span></p>
            <p><strong>শিক্ষার্থীর নাম:</strong> <span id="receipt-student-name"></span></p>
            <p><strong>শ্রেণি:</strong> <span id="receipt-class-name"></span></p>
            <p><strong>মেমো নং:</strong> <span id="receipt-memo-no"></span></p> 
            <p><strong>ফি-এর ধরন:</strong> <span id="receipt-fee-type"></span></p>
            <p><strong>মাস:</strong> <span id="receipt-fee-month"></span></p>
            <p><strong>জমা করা ফি:</strong> <span id="receipt-amount"></span> টাকা</p>
            <p><strong>পেমেন্টের মাধ্যম:</strong> <span id="receipt-payment-method"></span></p>
            <p><strong>তারিখ:</strong> <span id="receipt-payment-date"></span></p>
        </div>
        <div class="receipt-footer">
            <p>ধন্যবাদ</p>
        </div>
        <div class="receipt-buttons">
            <button id="printBtn"><i class="fas fa-print"></i> প্রিন্ট</button>
            <button id="closeBtn"><i class="fas fa-times"></i> বন্ধ করুন</button>
        </div>
    </div>
</div>

<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> স্কুল ম্যানেজমেন্ট সিস্টেম। সর্বস্বত্ব সংরক্ষিত।</p>
</div>

<script>
    const receiptOverlay = document.getElementById('receipt-popup-overlay');
    const studentDetailsOverlay = document.getElementById('student-details-overlay'); // নতুন
    const printBtn = document.getElementById('printBtn');
    const closeBtn = document.getElementById('closeBtn');
    const closeStudentBtn = document.getElementById('closeStudentBtn'); // নতুন

    // --- রসিদ দেখানোর ফাংশন (আগে থেকেই ছিল) ---
    function showReceipt(paymentId) {
        // Assume 'get_receipt_data.php' exists and fetches data for the receipt.
        fetch(`get_receipt_data.php?payment_id=${paymentId}`) 
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    const banglaMonths = {
                        '01': 'জানুয়ারি', '02': 'ফেব্রুয়ারি', '03': 'মার্চ',
                        '04': 'এপ্রিল', '05': 'মে', '06': 'জুন',
                        '07': 'জুলাই', '08': 'আগস্ট', '09': 'সেপ্টেম্বর',
                        '10': 'অক্টোবর', '11': 'নভেম্বর', '12': 'ডিসেম্বর'
                    };
                    let feeMonthInBangla = '-';
                    if (data.data.fee_month) {
                        const [year, month] = data.data.fee_month.split('-');
                        feeMonthInBangla = `${banglaMonths[month]} ${year}`;
                    }
                    
                    document.getElementById('receipt-student-id').textContent = data.data.student_id;
                    document.getElementById('receipt-student-name').textContent = data.data.student_name;
                    document.getElementById('receipt-class-name').textContent = data.data.class_name;
                    document.getElementById('receipt-memo-no').textContent = data.data.memo_no || '-'; 
                    document.getElementById('receipt-fee-type').textContent = data.data.category_name;
                    document.getElementById('receipt-fee-month').textContent = feeMonthInBangla;
                    document.getElementById('receipt-amount').textContent = parseFloat(data.data.amount).toFixed(0);
                    document.getElementById('receipt-payment-method').textContent = data.data.payment_method || 'N/A';
                    document.getElementById('receipt-payment-date').textContent = data.data.payment_date;
                    
                    // পপআপ দেখানো হচ্ছে
                    receiptOverlay.style.display = 'flex';
                } else {
                    alert('রসিদের তথ্য খুঁজে পাওয়া যায়নি।');
                }
            })
            .catch(error => {
                console.error('Error fetching receipt data:', error);
                alert('রসিদ লোড করতে সমস্যা হয়েছে।');
            });
    }

    // --- নতুন ফাংশন: শিক্ষার্থীর তথ্য দেখানোর জন্য (আপডেট করা) ---
    function showStudentDetails(studentId) {
        // 'get_student_details.php' ফাইল থেকে ডেটা আনা হচ্ছে।
        fetch(`get_student_details.php?student_id=${studentId}`)
            .then(response => response.json())
            .then(data => {
                if (data.status === 'success') {
                    const student = data.data;
                    document.getElementById('student-popup-name').textContent = `শিক্ষার্থী: ${student.student_name} (${student.class_name})`;
                    document.getElementById('s-id').textContent = student.student_id;
                    document.getElementById('s-name').textContent = student.student_name;
                    document.getElementById('s-class').textContent = student.class_name;
                    document.getElementById('s-roll').textContent = student.class_roll;
                    document.getElementById('s-dob').textContent = student.dob || 'N/A'; // পরিবর্তিত নাম
                    document.getElementById('s-father').textContent = student.father_name;
                    document.getElementById('s-mother').textContent = student.mother_name;
                    document.getElementById('s-phone').textContent = student.phone_number || 'N/A';
                    document.getElementById('s-admission-date').textContent = student.admission_date || 'N/A'; // পরিবর্তিত নাম

                    studentDetailsOverlay.style.display = 'flex'; // পপআপ দেখানো হচ্ছে
                } else {
                    alert('শিক্ষার্থীর তথ্য খুঁজে পাওয়া যায়নি।');
                    console.error('Error details:', data.message || 'Unknown error');
                }
            })
            .catch(error => {
                console.error('Error fetching student data:', error);
                alert('শিক্ষার্থীর তথ্য লোড করতে সমস্যা হয়েছে। অনুগ্রহ করে কনসোল দেখুন।');
            });
    }
    
    // --- ইভেন্ট লিসেনার্স ---
    
    // রসিদ পপআপ বন্ধ করা
    closeBtn.addEventListener('click', function() {
        receiptOverlay.style.display = 'none';
    });
    
    // শিক্ষার্থীর তথ্য পপআপ বন্ধ করা (নতুন)
    closeStudentBtn.addEventListener('click', function() {
        studentDetailsOverlay.style.display = 'none';
    });

    // প্রিন্ট বাটন ফাংশন
    printBtn.addEventListener('click', function() {
        window.print();
    });
</script>

</body>
</html>