<?php
session_start();
// পাথের সঠিকতা নিশ্চিত করুন
include '../../includes/db_connection.php'; 

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    die("আপনার এই পাতা ব্যবহারের অনুমতি নেই।");
}

$error = '';
$teacher_salary_cat_id = null;

// ===========================================
// ১. 'শিক্ষক বেতন' ক্যাটাগরির ID খুঁজে বের করা
// ===========================================
$category_sql = "SELECT category_id FROM expense_categories WHERE category_name = 'শিক্ষক বেতন' LIMIT 1";
$category_result = $conn->query($category_sql);
if ($category_result && $category_result->num_rows > 0) {
    $teacher_salary_cat_id = $category_result->fetch_assoc()['category_id'];
}

// ===========================================
// ২. বেতন পরিশোধের ডেটা লোড করা
// ===========================================
$salary_payments = [];

if ($teacher_salary_cat_id !== null) {
    // expenses এবং teachers টেবিলের সাথে JOIN করে রিপোর্ট তৈরি করা
    $sql = "SELECT 
                e.voucher_no, 
                e.expense_date, 
                e.amount, 
                e.salary_month,
                CONCAT(t.first_name, ' ', t.last_name) AS teacher_name
            FROM 
                expenses e
            INNER JOIN 
                teachers t ON e.teacher_id = t.teacher_id
            WHERE 
                e.category_id = ?
            ORDER BY 
                e.expense_date DESC, e.salary_month DESC";

    $stmt = $conn->prepare($sql);
    if ($stmt) {
        $stmt->bind_param("i", $teacher_salary_cat_id);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            $salary_payments[] = $row;
        }
        $stmt->close();
    } else {
        $error = "SQL প্রস্তুতির সমস্যা: " . $conn->error;
    }
} else {
    $error = "ডাটাবেসে 'শিক্ষক বেতন' নামের কোনো খাতের ID পাওয়া যায়নি। অনুগ্রহ করে নিশ্চিত করুন যে এই নামের একটি খরচ ক্যাটাগরি আছে।";
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <div class="marquee-container">
        <marquee behavior="scroll" direction="left" scrollamount="6" class="marquee-text">
            📞 আসসালামু আলাইকুম,আমি আরমান এ সফটওয়্যার তৈরি করেছি । যদি কোন ভুলের কারনে আপনার এই সপ্টার ব্যবহারে কোনো সমস্যা হলে আমাকে কল করুন: 
            <span style="color: #e74c3c; font-size: 1.2em; margin: 0 15px;">০১৮৭৪৮১২৮৪৯</span> 
            📞 আসসালামু আলাইকুম,আমি আরমান এ সফটওয়্যার তৈরি করেছি । যদি কোন ভুলের কারনে আপনার এই সপ্টার ব্যবহারে কোনো সমস্যা হলে আমাকে কল করুন: 
            <span style="color: #e74c3c; font-size: 1.2em; margin: 0 15px;">০১৮৭৪৮১২৮৪৯</span>
        </marquee>
    </div>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>শিক্ষক বেতন পরিশোধের রিপোর্ট</title>
    <link rel="stylesheet" href="../../public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .report-container {
            max-width: 1000px;
            margin: 50px auto;
            padding: 30px;
            background-color: #ffffff;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        }
        .report-container h2 {
            text-align: center;
            color: #2c3e50;
            margin-bottom: 25px;
            border-bottom: 2px solid #3498db;
            padding-bottom: 10px;
        }
        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .data-table th, .data-table td {
            border: 1px solid #ddd;
            padding: 12px 15px;
            text-align: left;
        }
        .data-table th {
            background-color: #3498db;
            color: white;
            font-weight: bold;
            text-transform: uppercase;
        }
        .data-table tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        .data-table tr:hover {
            background-color: #e9e9e9;
        }
        .data-table td:nth-child(4) { /* Salary Month column */
            white-space: nowrap;
        }
        /* ব্যাক বাটনের CSS */
        .back-btn {
            background-color: #7f8c8d;
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 5px;
            font-size: 15px;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            margin-top: 20px;
        }
        .back-btn:hover {
            background-color: #95a5a6;
        }
        .alert-error {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
            font-weight: bold;
            text-align: center;
            color: #721c24;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>
<div class="header">
    <h1>শিক্ষক বেতন রিপোর্ট</h1>
</div>
<div class="content">
    <div class="report-container">
        <h2><i class="fas fa-hand-holding-usd"></i> শিক্ষক বেতন পরিশোধের তালিকা</h2>
        
        <?php if ($error): ?>
            <p class="alert-error"><i class="fas fa-exclamation-triangle"></i> <?php echo $error; ?></p>
        <?php endif; ?>

        <?php if (!empty($salary_payments)): ?>
        <table class="data-table">
            <thead>
                <tr>
                    <th>ভাউচার নং</th>
                    <th>পরিশোধের তারিখ</th>
                    <th>শিক্ষকের নাম</th>
                    <th>বেতন মাস</th>
                    <th>পরিমাণ (টাকা)</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $total_paid = 0;
                foreach ($salary_payments as $payment): 
                    $total_paid += $payment['amount'];
                    // Salary Month (YYYY-MM-DD) থেকে শুধু মাস-বছর বের করা
                    $salary_month_formatted = date('F Y', strtotime($payment['salary_month']));
                ?>
                <tr>
                    <td><?php echo htmlspecialchars($payment['voucher_no']); ?></td>
                    <td><?php echo htmlspecialchars($payment['expense_date']); ?></td>
                    <td><?php echo htmlspecialchars($payment['teacher_name']); ?></td>
                    <td><?php echo $salary_month_formatted; ?></td>
                    <td style="text-align: right; font-weight: bold;"><?php echo number_format($payment['amount'], 2); ?></td>
                </tr>
                <?php endforeach; ?>
                <tr>
                    <td colspan="4" style="text-align: right; font-weight: bold; background-color: #ecf0f1;">মোট পরিশোধ</td>
                    <td style="text-align: right; font-weight: bold; background-color: #ecf0f1; color: #2ecc71;"><?php echo number_format($total_paid, 2); ?></td>
                </tr>
            </tbody>
        </table>
        <?php else: ?>
             <?php if ($teacher_salary_cat_id !== null): ?>
                <p style="text-align: center; padding: 20px; border: 1px solid #eee;">কোনো শিক্ষকের বেতন পরিশোধের তথ্য পাওয়া যায়নি।</p>
            <?php endif; ?>
        <?php endif; ?>

        <div style="text-align: center;">
            <a href="expense_report.php" class="back-btn"><i class="fas fa-arrow-left"></i> খরচ তালিকায় ফিরে যান</a>
        </div>
    </div>
</div>
</body>
</html>