<?php
session_start();
include '../../includes/db_connection.php'; 

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    die("আপনার এই পাতা ব্যবহারের অনুমতি নেই।");
}

if (!isset($_GET['voucher_no']) || empty($_GET['voucher_no'])) {
    header("Location: expense_report.php");
    exit();
}

$voucher_no = $_GET['voucher_no'];
$message = '';
$error = '';

// ডিলেট করার লজিক
$sql = "DELETE FROM expenses WHERE voucher_no = ?";
$stmt = $conn->prepare($sql);

if ($stmt === false) {
    $error = "SQL প্রস্তুতে সমস্যা: " . $conn->error;
} else {
    $stmt->bind_param("s", $voucher_no);
    
    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            $message = "ভাউচার নং: " . htmlspecialchars($voucher_no) . " এর সব ব্যয় সফলভাবে মুছে ফেলা হয়েছে।";
        } else {
            $error = "ভাউচার নং: " . htmlspecialchars($voucher_no) . " এর কোনো এন্ট্রি পাওয়া যায়নি বা মুছে ফেলা সম্ভব হয়নি।";
        }
    } else {
        $error = "ব্যয় মুছে ফেলতে ব্যর্থ: " . $stmt->error;
    }
    $stmt->close();
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ব্যয় ডিলেট</title>
    <link rel="stylesheet" href="../../public/css/style.css"> 
    <style>
        .container { max-width: 600px; margin: 50px auto; padding: 20px; background-color: #fff; border-radius: 8px; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); text-align: center; }
        .message-success { color: green; font-weight: bold; font-size: 1.2em; }
        .message-error { color: red; font-weight: bold; font-size: 1.2em; }
    </style>
</head>
<body>
<div class="header">
    <h1>ব্যয় ডিলেট</h1>
</div>
<div class="container">
    <?php if ($message): ?>
        <p class="message-success"><?php echo $message; ?></p>
    <?php endif; ?>
    <?php if ($error): ?>
        <p class="message-error"><?php echo $error; ?></p>
    <?php endif; ?>
    
    <p style="margin-top: 30px;"><a href="expense_report.php" style="color: #007bff; text-decoration: none; font-weight: bold;">← ব্যয় রিপোর্টে ফিরে যান</a></p>
</div>
</body>
</html>