<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 0);

include '../../includes/db_connection.php';

// ✅ এই লাইনটি Exception হ্যান্ডলিং সক্রিয় করে
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'Admin') {
    header("Location: /school_management/public/dashboard.php");
    exit();
}

$message = '';
$error = '';
$voucher_no = $expense_date = $description = $paid_to = '';
$category_id_selected = '';

// ==============================
// ১. শিক্ষকের ডেটা লোড
// ==============================
$teachers = [];
$teacher_map = [];
$teacher_sql = "SELECT teacher_id, CONCAT(first_name, ' ', last_name) AS name FROM teachers ORDER BY name ASC";
$teacher_result = $conn->query($teacher_sql);
if ($teacher_result) {
    while ($row = $teacher_result->fetch_assoc()) {
        $teachers[] = $row;
        $teacher_map[$row['teacher_id']] = $row['name'];
    }
}

// ==============================
// ২. খাতের ডেটা লোড
// ==============================
$categories = [];
$teacher_salary_cat_id = null;
$category_sql = "SELECT category_id, category_name FROM expense_categories WHERE is_active = TRUE ORDER BY category_name ASC";
$category_result = $conn->query($category_sql);
if ($category_result) {
    while ($row = $category_result->fetch_assoc()) {
        $categories[] = $row;
        if (trim($row['category_name']) === 'শিক্ষক বেতন') {
            $teacher_salary_cat_id = $row['category_id'];
        }
    }
}

// ==============================
// ৩. ফর্ম সাবমিশন
// ==============================
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $voucher_no = trim($_POST['voucher_no']);
    $expense_date = $_POST['expense_date'];
    $category_id = $_POST['category_id'];
    $description = htmlspecialchars(trim($_POST['description'] ?? ''), ENT_QUOTES, 'UTF-8');
    $paid_to = htmlspecialchars(trim($_POST['paid_to'] ?? ''), ENT_QUOTES, 'UTF-8');
    $received_by = $_SESSION['user_id'];
    $amount_single = filter_var($_POST['amount_single'] ?? 0, FILTER_VALIDATE_FLOAT);
    $category_id_selected = $category_id;

    if (empty($voucher_no) || empty($expense_date) || empty($category_id)) {
        echo "<script>alert('⚠️ ভাউচার নং, তারিখ এবং খাত অবশ্যই পূরণ করতে হবে।'); window.history.back();</script>";
        exit();
    }

    $entries_to_save = [];

    // যদি শিক্ষক বেতন হয়
    if ($category_id == $teacher_salary_cat_id) {
        $salary_data = $_POST['salary_entries'] ?? [];
        if (empty($salary_data)) {
            echo "<script>alert('⚠️ শিক্ষক বেতন খাতের জন্য কমপক্ষে একজন শিক্ষকের বেতন এন্ট্রি করতে হবে।'); window.history.back();</script>";
            exit();
        }

        foreach ($salary_data as $entry) {
            $teacher_id = filter_var($entry['teacher_id'], FILTER_VALIDATE_INT);
            $salary_month_input = trim($entry['salary_month']);
            $amount = filter_var($entry['amount'], FILTER_VALIDATE_FLOAT);

            if (empty($teacher_id) || empty($salary_month_input) || $amount <= 0) {
                echo "<script>alert('⚠️ শিক্ষক, মাস এবং টাকার পরিমাণ সঠিক হতে হবে।'); window.history.back();</script>";
                exit();
            }

            $salary_month_db = $salary_month_input . '-01'; 
            $teacher_name = $teacher_map[$teacher_id] ?? 'অজানা শিক্ষক';
            $salary_month_formatted = date("F Y", strtotime($salary_month_db));
            $entry_description = "শিক্ষক: {$teacher_name}, বেতন মাস: {$salary_month_formatted}";
            if (!empty($description)) {
                $entry_description .= " | মূল বিবরণ: {$description}";
            }

            $entries_to_save[] = [
                'category_id' => (int)$category_id,
                'amount' => $amount,
                'description' => $entry_description,
                'teacher_id' => $teacher_id,
                'salary_month' => $salary_month_db
            ];
        }
    } else {
        // অন্য খাতের জন্য সিঙ্গেল এন্ট্রি
        if ($amount_single <= 0) {
            echo "<script>alert('⚠️ টাকার পরিমাণ অবশ্যই শূন্যের চেয়ে বেশি হতে হবে।'); window.history.back();</script>";
            exit();
        }

        $entries_to_save[] = [
            'category_id' => (int)$category_id,
            'amount' => $amount_single,
            'description' => $description,
            'teacher_id' => NULL,
            'salary_month' => NULL
        ];
    }

    // ==============================
    // ডাটাবেজে ইনসার্ট
    // ==============================
    $conn->begin_transaction();
    $success_count = 0;

    $sql = "INSERT INTO expenses 
            (voucher_no, expense_date, category_id, amount, description, paid_to, received_by, teacher_id, salary_month) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);

    foreach ($entries_to_save as $entry) {
        $teacher_id_bind = $entry['teacher_id'] === NULL ? 0 : $entry['teacher_id'];
        $salary_month_bind = $entry['salary_month'] === NULL ? '' : $entry['salary_month'];

        $stmt->bind_param(
            "ssdississ",
            $voucher_no,
            $expense_date,
            $entry['category_id'],
            $entry['amount'],
            $entry['description'],
            $paid_to,
            $received_by,
            $teacher_id_bind,
            $salary_month_bind
        );

        // ✅ ডুপ্লিকেট ও এরর হ্যান্ডলিং
        try {
            $stmt->execute();
            $success_count++;
        } catch (mysqli_sql_exception $e) {
            if ($e->getCode() == 1062 || strpos($e->getMessage(), 'Duplicate entry') !== false) {
                echo "<script>alert('⚠️ ডুপ্লিকেট এন্ট্রি! এই শিক্ষক বা মাসের তথ্য আগেই সংরক্ষিত হয়েছে।'); window.history.back();</script>";
            } else {
                $error_msg = addslashes($e->getMessage());
                echo "<script>alert('❌ একটি ত্রুটি ঘটেছে: $error_msg'); window.history.back();</script>";
            }
            $conn->rollback();
            exit();
        }
    }

    $conn->commit();
    echo "<script>alert('✅ সফলভাবে {$success_count} টি ব্যয় যুক্ত হয়েছে!'); window.location.href='add_expense.php';</script>";
    exit();
}

$conn->close();
?>








<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>নতুন ব্যয় এন্ট্রি</title>
    <link rel="stylesheet" href="../../public/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .form-container {
            max-width: 800px; 
            margin: 50px auto;
            padding: 30px;
            background-color: #ffffff;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        }
        .form-container h2 {
            text-align: center;
            color: #34495e;
            margin-bottom: 25px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #34495e;
        }
        .form-group input[type="text"],
        .form-group input[type="date"],
        .form-group input[type="month"],
        .form-group input[type="number"],
        .form-group textarea,
        .form-group select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ccc;
            border-radius: 5px;
            box-sizing: border-box;
            font-size: 16px;
        }
        .form-actions {
            display: flex;
            justify-content: space-between; 
            align-items: center;
            margin-top: 30px;
        }
        .form-actions .submit-btn {
            background-color: #2ecc71;
            color: white;
            padding: 12px 25px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.3s;
        }
        .form-actions .submit-btn:hover {
            background-color: #27ae60;
        }
        .back-btn {
            background-color: #3498db; 
            color: white;
            text-decoration: none;
            padding: 12px 25px;
            border-radius: 5px;
            font-size: 16px;
            display: inline-flex;
            align-items: center;
            gap: 5px;
            transition: background-color 0.3s;
        }
        .back-btn:hover {
            background-color: #2980b9;
        }
        .alert-message {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 5px;
            font-weight: bold;
            text-align: center;
        }
        .alert-success {
            color: #155724;
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
        }
        .alert-error {
            color: #721c24;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
        }
        
        /* শিক্ষক বেতনের টেবিল স্টাইল */
        #teacher_salary_details {
            border: 1px dashed #f39c12;
            padding: 15px;
            background-color: #fffaf0;
            border-radius: 5px;
            margin-top: 10px;
        }
        #teacher_salary_details h4 {
            margin-top: 0; 
            color: #f39c12;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-bottom: 10px;
            border-bottom: 1px dotted #f39c12;
        }
        .salary-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .salary-table th, .salary-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .salary-table th {
            background-color: #f7f7f7;
        }
        .remove-btn {
            background-color: #e74c3c;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
        }
        .add-row-btn {
            background-color: #3498db;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            cursor: pointer;
            font-weight: bold;
        }
    </style>
</head>
<body>
<div class="header">
    <h1>নতুন ব্যয় এন্ট্রি করুন</h1>
    <div class="marquee-container">
        <marquee behavior="scroll" direction="left" scrollamount="6" class="marquee-text">
            📞 আসসালামু আলাইকুম,আমি আরমান এ সফটওয়্যার তৈরি করেছি । যদি কোন ভুলের কারনে আপনার এই সপ্টার ব্যবহারে কোনো সমস্যা হলে আমাকে কল করুন: 
            <span style="color: #e74c3c; font-size: 1.2em; margin: 0 15px;">০১৮৭৪৮১২৮৪৯</span> 
            📞 আসসালামু আলাইকুম,আমি আরমান এ সফটওয়্যার তৈরি করেছি । যদি কোন ভুলের কারনে আপনার এই সপ্টার ব্যবহারে কোনো সমস্যা হলে আমাকে কল করুন: 
            <span style="color: #e74c3c; font-size: 1.2em; margin: 0 15px;">০১৮৭৪৮১২৮৪৯</span>
        </marquee>
    </div>
</div>
<div class="content">
    <div class="form-container">
        <h2><i class="fas fa-file-invoice-dollar"></i> ব্যয়ের হিসাব যোগ করুন</h2>
        
        <?php if ($message): ?>
            <p class="alert-message alert-success"><i class="fas fa-check-circle"></i> <?php echo $message; ?></p>
        <?php endif; ?>
        
        <?php if ($error): ?>
            <p class="alert-message alert-error"><i class="fas fa-exclamation-triangle"></i> <?php echo $error; ?></p>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label for="voucher_no">ভাউচার নং:</label>
                <input type="text" id="voucher_no" name="voucher_no" required value="<?php echo htmlspecialchars($voucher_no); ?>">
            </div>

            <div class="form-group">
                <label for="expense_date">তারিখ:</label>
                <input type="date" id="expense_date" name="expense_date" required value="<?php echo htmlspecialchars($expense_date ? $expense_date : date('Y-m-d')); ?>">
            </div>

            <div class="form-group">
                <label for="category_id">ব্যয়ের খাত <span style="color: red;">*</span>:</label>
                <select id="category_id" name="category_id" required onchange="toggleExpenseFields()">
                    <option value="">-- নির্বাচন করুন --</option>
                    <?php foreach ($categories as $category): ?>
                        <option value="<?php echo htmlspecialchars($category['category_id']); ?>" 
                                <?php echo $category_id_selected == $category['category_id'] ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($category['category_name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div id="teacher_salary_details" style="display:none;">
                <h4>
                    <i class="fas fa-money-check-alt"></i> বেতন পরিশোধের বিস্তারিত
                    <button type="button" class="add-row-btn" onclick="addSalaryRow()"><i class="fas fa-plus"></i> শিক্ষক যোগ করুন</button>
                </h4>
                
                <div style="overflow-x: auto;">
                    <table class="salary-table" id="salary_entries_table">
                        <thead>
                            <tr>
                                <th style="width: 40%;">শিক্ষকের নাম</th>
                                <th style="width: 30%;">কোন মাসের বেতন</th>
                                <th style="width: 20%;">পরিমাণ (টাকা)</th>
                                <th style="width: 10%;">মুছুন</th>
                            </tr>
                        </thead>
                        <tbody>
                            </tbody>
                    </table>
                </div>
            </div>
            
            <div id="single_expense_details">
                <div class="form-group">
                    <label for="amount_single">পরিমাণ (টাকা):</label>
                    <input type="number" id="amount_single" name="amount_single" step="0.01" min="0" value="">
                </div>
            </div>

            <div class="form-group">
                <label for="paid_to">যাকে পরিশোধ করা হয়েছে (ঐচ্ছিক):</label>
                <input type="text" id="paid_to" name="paid_to" value="<?php echo htmlspecialchars($paid_to); ?>">
            </div>
            
            <div class="form-group">
                <label for="description">বিবরণ (ঐচ্ছিক):</label>
                <textarea id="description" name="description" rows="3"><?php echo htmlspecialchars($description); ?></textarea>
            </div>

            <div class="form-actions">
                <a href="expense_report.php" class="back-btn"><i class="fas fa-arrow-left"></i> তালিকায় ফিরে যান</a>
                <button type="submit" class="submit-btn"><i class="fas fa-save"></i> ব্যয় এন্ট্রি করুন</button>
            </div>
        </form>
    </div>
</div>

<script>
    const TEACHER_SALARY_CAT_ID = '<?php echo $teacher_salary_cat_id; ?>';
    const categorySelect = document.getElementById('category_id');
    const teacherSalaryDetails = document.getElementById('teacher_salary_details');
    const singleExpenseDetails = document.getElementById('single_expense_details');
    const salaryTableBody = document.querySelector('#salary_entries_table tbody');
    let rowCounter = 0;
    
    // PHP থেকে শিক্ষকের ডেটা JSON এ রূপান্তর
    const teachers = <?php echo json_encode($teachers); ?>;

    function createTeacherSelectHtml(selectedValue = '') {
        let options = '<option value="">-- শিক্ষক নির্বাচন করুন --</option>';
        teachers.forEach(teacher => {
            options += `<option value="${teacher.teacher_id}" ${selectedValue == teacher.teacher_id ? 'selected' : ''}>${teacher.name}</option>`;
        });
        return options;
    }

    function addSalaryRow(teacherId = '', salaryMonth = '', amount = '') {
        const newRow = salaryTableBody.insertRow();
        newRow.setAttribute('data-row-id', rowCounter);
        
        // ১. শিক্ষকের নাম (Select)
        newRow.insertCell().innerHTML = `
            <select name="salary_entries[${rowCounter}][teacher_id]" required>
                ${createTeacherSelectHtml(teacherId)}
            </select>
        `;

        // ২. কোন মাসের বেতন (Month)
        newRow.insertCell().innerHTML = `
            <input type="month" name="salary_entries[${rowCounter}][salary_month]" value="${salaryMonth}" required>
        `;
        
        // ৩. পরিমাণ (Number)
        newRow.insertCell().innerHTML = `
            <input type="number" name="salary_entries[${rowCounter}][amount]" step="0.01" min="0.01" value="${amount}" required>
        `;

        // ৪. মুছুন (Button)
        newRow.insertCell().innerHTML = `
            <button type="button" class="remove-btn" onclick="removeSalaryRow(this)"><i class="fas fa-times"></i></button>
        `;
        
        rowCounter++;
    }

    function removeSalaryRow(button) {
        const row = button.closest('tr');
        row.remove();
    }

    function toggleExpenseFields() {
        const selectedCategoryId = categorySelect.value;
        const isTeacherSalary = (selectedCategoryId && selectedCategoryId == TEACHER_SALARY_CAT_ID);

        // সিঙ্গেল এমাউন্ট ফিল্ড
        const amountSingleField = document.getElementById('amount_single');
        // বিবরণ ফিল্ড
        const descriptionField = document.getElementById('description');

        if (isTeacherSalary) {
            // শিক্ষক বেতনের ফিল্ড দেখান, অন্যটি লুকান
            teacherSalaryDetails.style.display = 'block';
            singleExpenseDetails.style.display = 'none';
            
            // বেতনের জন্য সিঙ্গেল এমাউন্ট ফিল্ডের রিকয়ারমেন্ট সরান
            amountSingleField.required = false;
        } else {
            // অন্যান্য খরচের ফিল্ড দেখান, বেতনেরটি লুকান
            teacherSalaryDetails.style.display = 'none';
            singleExpenseDetails.style.display = 'block';
            
            // অন্যান্য খরচের জন্য সিঙ্গেল এমাউন্ট ফিল্ড রিকয়ারড করুন
            amountSingleField.required = true;
            
            // যদি বেতন ক্যাটাগরি না হয়, বেতন টেবিলের সব রো সরিয়ে দিন যাতে ভুল ডেটা সাবমিট না হয়।
            salaryTableBody.innerHTML = '';
            rowCounter = 0;
        }
    }

    window.onload = function() {
        // পেজ লোডের সময় প্রাথমিক ডিসপ্লে সেট করা
        toggleExpenseFields();
        
        // যদি রি-পপুলেশন দরকার হয় (যেমন: সাবমিটের পর এরর থাকলে), এবং বেতন ক্যাটাগরি সিলেক্ট করা থাকে কিন্তু কোনো রো না থাকে, তবে একটি ফাঁকা রো যোগ করুন
        if (categorySelect.value == TEACHER_SALARY_CAT_ID && salaryTableBody.rows.length === 0) {
              addSalaryRow();
        }
    };
</script>

</body>
</html>