<?php
session_start();
// পাথের সঠিকতা নিশ্চিত করুন
include '../includes/db_connection.php';

// টাইমজোন সঠিকভাবে সেট করা হলো
date_default_timezone_set('Asia/Dhaka');

// ===============================================
// ডাটা ফেচিং এবং রিপোর্ট ক্যালকুলেশন (অপরিবর্তিত)
// ===============================================

// ১. মোট শিক্ষার্থী
$total_students_sql = "SELECT COUNT(*) AS total FROM students";
$total_students_result = $conn->query($total_students_sql);
$total_students = $total_students_result->fetch_assoc()['total'];

// ২. ছেলে শিক্ষার্থী
$total_male_students_sql = "SELECT COUNT(*) AS total FROM students WHERE gender = 'male'";
$total_male_students_result = $conn->query($total_male_students_sql);
$total_male_students = $total_male_students_result->fetch_assoc()['total'];

// ৩. মেয়ে শিক্ষার্থী
$total_female_students_sql = "SELECT COUNT(*) AS total FROM students WHERE gender = 'female'";
$total_female_students_result = $conn->query($total_female_students_sql);
$total_female_students = $total_female_students_result->fetch_assoc()['total'];

// ৪. আজকের ফি সংগ্রহ (Fee Table)
$today_fee_collection_sql = "SELECT COALESCE(SUM(amount), 0) AS total FROM fees WHERE DATE(payment_date) = CURDATE()";
$today_fee_collection_result = $conn->query($today_fee_collection_sql);
$today_fee_collection = $today_fee_collection_result->fetch_assoc()['total'];

// ৫. এই মাসের ফি সংগ্রহ (Fee Table)
$this_month_fee_collection_sql = "SELECT COALESCE(SUM(amount), 0) AS total FROM fees WHERE YEAR(payment_date) = YEAR(CURDATE()) AND MONTH(payment_date) = MONTH(CURDATE())";
$this_month_fee_collection_result = $conn->query($this_month_fee_collection_sql);
$this_month_fee_collection = $this_month_fee_collection_result->fetch_assoc()['total'];

// ৬. আজকের অন্যান্য আয় (other_incomes Table)
$today_other_income_sql = "SELECT COALESCE(SUM(amount), 0) AS total FROM other_incomes WHERE DATE(income_date) = CURDATE()";
$today_other_income_result = $conn->query($today_other_income_sql);
$today_other_income = $today_other_income_result->fetch_assoc()['total'];

// ৭. এই মাসের অন্যান্য আয় (other_incomes Table)
$this_month_other_income_sql = "SELECT COALESCE(SUM(amount), 0) AS total FROM other_incomes WHERE YEAR(income_date) = YEAR(CURDATE()) AND MONTH(income_date) = MONTH(CURDATE())";
$this_month_other_income_result = $conn->query($this_month_other_income_sql);
$this_month_other_income = $this_month_other_income_result->fetch_assoc()['total'];

// ৮. মোট সংগ্রহ ক্যালকুলেশন (ফি + অন্যান্য আয়)
$today_total_collection = $today_fee_collection + $today_other_income;
$this_month_total_collection = $this_month_fee_collection + $this_month_other_income;

// ৯. আজকের মোট ব্যয় (Expense Table - NEW)
$today_total_expense_sql = "SELECT COALESCE(SUM(amount), 0) AS total FROM expenses WHERE DATE(expense_date) = CURDATE()";
$today_total_expense_result = $conn->query($today_total_expense_sql);
$today_total_expense = $today_total_expense_result->fetch_assoc()['total'];

// ১০. এই মাসের মোট ব্যয় (Expense Table - NEW)
$this_month_total_expense_sql = "SELECT COALESCE(SUM(amount), 0) AS total FROM expenses WHERE YEAR(expense_date) = YEAR(CURDATE()) AND MONTH(expense_date) = MONTH(CURDATE())";
$this_month_total_expense_result = $conn->query($this_month_total_expense_sql);
$this_month_total_expense = $this_month_total_expense_result->fetch_assoc()['total'];


// ===============================================
// ✅ চার্ট ডেটার জন্য গত ৬ মাসের মাসিক আয় (ফি + অন্যান্য আয়) ফেচিং (অপরিবর্তিত)
// ===============================================

$monthly_income_data = array();
$current_year = date('Y');
$current_month = date('m');

// গত ৬ মাসের জন্য লুপ চালানো
for ($i = 5; $i >= 0; $i--) {
    $month_ts = strtotime("-$i month");
    $month_label_en = date('F', $month_ts);
    $year = date('Y', $month_ts);
    $month = date('m', $month_ts);

    // মোট ফি সংগ্রহ (fees)
    $fee_sql = "SELECT COALESCE(SUM(amount), 0) AS total_fee FROM fees WHERE YEAR(payment_date) = ? AND MONTH(payment_date) = ?";
    $stmt_fee = $conn->prepare($fee_sql);
    $stmt_fee->bind_param("ss", $year, $month);
    $stmt_fee->execute();
    $fee_result = $stmt_fee->get_result()->fetch_assoc();
    $total_fee = $fee_result['total_fee'];
    $stmt_fee->close();

    // অন্যান্য আয় (other_incomes)
    $other_income_sql = "SELECT COALESCE(SUM(amount), 0) AS total_other FROM other_incomes WHERE YEAR(income_date) = ? AND MONTH(income_date) = ?";
    $stmt_income = $conn->prepare($other_income_sql);
    $stmt_income->bind_param("ss", $year, $month);
    $stmt_income->execute();
    $income_result = $stmt_income->get_result()->fetch_assoc();
    $total_other_income = $income_result['total_other'];
    $stmt_income->close();

    $total_monthly_income = $total_fee + $total_other_income;

    // বাংলা মাস ম্যাপিং করে ডাটা সেভ করা
    $bangla_months_chart = array(
        'January' => 'জানুয়ারি', 'February' => 'ফেব্রুয়ারি', 'March' => 'মার্চ',
        'April' => 'এপ্রিল', 'May' => 'মে', 'June' => 'জুন',
        'July' => 'জুলাই', 'August' => 'আগস্ট', 'September' => 'সেপ্টেম্বর',
        'October' => 'অক্টোবর', 'November' => 'নভেম্বর', 'December' => 'ডিসেম্বর'
    );
    $month_label_bn = $bangla_months_chart[$month_label_en] ?? $month_label_en;
    
    // ডাটা অ্যারেতে যুক্ত করা
    $monthly_income_data[] = [
        'month' => $month_label_bn . " " . substr($year, 2), // যেমন: 'সেপ্টেম্বর ২৪'
        'income' => $total_monthly_income
    ];
}

$chart_labels = json_encode(array_column($monthly_income_data, 'month'));
$chart_data = json_encode(array_column($monthly_income_data, 'income'));


// ===============================================
// বাংলা তারিখ এবং সময় কনভার্সন লজিক (অপরিবর্তিত)
// ===============================================

$current_date_bangla = date('l, j F Y', strtotime('now'));
$current_time = date('h:i:s A', strtotime('now'));

// বাংলা সংখ্যা ম্যাপিং
$bangla_numbers = array('১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯', '০');
$english_numbers = array('1', '2', '3', '4', '5', '6', '7', '8', '9', '0');
$current_date_bangla = str_replace($english_numbers, $bangla_numbers, $current_date_bangla);

// বাংলা মাস ম্যাপিং
$bangla_months = array(
    'January' => 'জানুয়ারি', 'February' => 'ফেব্রুয়ারি', 'March' => 'মার্চ',
    'April' => 'এপ্রিল', 'May' => 'মে', 'June' => 'জুন',
    'July' => 'জুলাই', 'August' => 'আগস্ট', 'September' => 'সেপ্টেম্বর',
    'October' => 'অক্টোবর', 'November' => 'নভেম্বর', 'December' => 'ডিসেম্বর'
);
$current_date_bangla = str_replace(array_keys($bangla_months), array_values($bangla_months), $current_date_bangla);

// বাংলা দিন ম্যাপিং
$bangla_days = array(
    'Sunday' => 'রবিবার', 'Monday' => 'সোমবার', 'Tuesday' => 'মঙ্গলবার',
    'Wednesday' => 'বুধবার', 'Thursday' => 'বৃহস্পতিবার', 'Friday' => 'শুক্রবার',
    'Saturday' => 'শনিবার'
);
$current_date_bangla = str_replace(array_keys($bangla_days), array_values($bangla_days), $current_date_bangla);

$conn->close();
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ড্যাশবোর্ড | Miftahul Najat Mohila Madrasah</title>
    <link rel="stylesheet" href="/school_management/public/css/style.css"> 
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        /* ফন্ট পরিবর্তন (বাংলা ফন্টের জন্য) */
        @import url('https://fonts.googleapis.com/css2?family=Tiro+Bangla&display=swap');
        
        body { 
            background-color: #f0f2f5; /* হালকা ব্যাকগ্রাউন্ড */
            font-family: 'Tiro Bangla', Arial, sans-serif;
            margin: 0; padding: 0; 
        }
        .header { 
            text-align: center; 
            background-color: #2c3e50; /* গাঢ় নীল */
            color: #ecf0f1; 
            padding-top: 20px; 
            padding-bottom: 0; 
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }
        .header h1 { margin: 0; font-size: 2.5em; }
        .header p { margin: 5px 0 0; font-size: 1.2em; }
        
        /* মারকিউ কন্টেইনার */
        .marquee-container {
            width: 100%;
            background-color: #e67e22; /* কমলা */
            color: #2c3e50; 
            padding: 8px 0;
            overflow: hidden;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.15);
            font-weight: bold;
            font-size: 1.1em;
            margin-top: 10px; 
            margin-bottom: 10px; 
        }
        
        .nav { background-color: #34495e; padding: 10px; display: flex; justify-content: center; flex-wrap: wrap; gap: 10px; }
        .nav a { 
            display: inline-block; color: white; padding: 10px 15px; text-decoration: none; 
            border-radius: 5px; background-color: #3498db; transition: background-color 0.3s, transform 0.2s; 
            font-size: 16px; text-align: center; border: 1px solid #2980b9; 
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        .nav a:hover { background-color: #2980b9; transform: translateY(-2px); }

        .container { 
            display: flex; 
            min-height: calc(100vh - 120px); 
            max-width: 1600px; 
            margin: 20px auto; 
            background-color: #fff; 
            border-radius: 12px; 
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1); 
            overflow: hidden;
        }
        
        .sidebar { 
            width: 280px; 
            background-color: #34495e; 
            padding: 20px 0; /* প্যাডিং উপরে-নিচে ঠিক রেখেছি */
            box-shadow: 4px 0 10px rgba(0, 0, 0, 0.1); 
            min-height: 100%;
        }
        .sidebar-title { 
            color: #ecf0f1; 
            text-align: center; 
            margin-bottom: 20px; 
            padding: 0 20px;
            border-bottom: 1px solid #4a627a;
            padding-bottom: 15px;
            font-size: 1.3em;
        }
        .menu-item { margin: 0 10px 8px; } /* সাইডবারের দুই পাশে সামান্য মার্জিন */
        .menu-btn { 
            background-color: #556a7f; 
            color: white; 
            padding: 12px 15px; 
            border: none; 
            width: 100%; 
            text-align: left; 
            cursor: pointer; 
            font-size: 1em; 
            border-radius: 5px; 
            transition: background-color 0.3s;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .menu-btn:hover { background-color: #7f8c8d; }
        .sub-menu { display: none; background-color: #495e72; padding-left: 10px; border-radius: 0 0 5px 5px; }
        .sub-menu a { display: block; color: white; padding: 8px 10px; text-decoration: none; transition: background-color 0.3s; border-left: 3px solid transparent; }
        .sub-menu a:hover { background-color: #556a7f; border-left: 3px solid #f1c40f; }

        .main-content { flex-grow: 1; padding: 20px 30px; } 
        .content-box { 
            background-color: #fff; 
            border-radius: 8px; 
        }
        
        /* তারিখ/সময় ডিসপ্লেকে আরও আধুনিক করা হলো */
        .datetime-display { 
            float: right; 
            background: linear-gradient(45deg, #3498db, #2ecc71); /* গ্রেডিয়েন্ট ব্যাকগ্রাউন্ড */
            color: white; 
            padding: 10px 15px; 
            border-radius: 8px; 
            text-align: center; 
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15); 
            margin-bottom: 20px; 
            font-size: 0.9em; 
        }
        .datetime-display h3 { margin: 0; font-size: 1em; font-weight: normal; }
        .datetime-display p { font-size: 1.8em; font-weight: bold; margin: 5px 0 0; }
        .clear { clear: both; }

        .main-content h2 { color: #2c3e50; border-bottom: 2px solid #ddd; padding-bottom: 10px; }
        .main-content h3 { color: #34495e; margin-top: 25px; margin-bottom: 15px; font-size: 1.5em; }
        
        /* ✅ সারাংশ রিপোর্ট কার্ডের উন্নত স্টাইল */
        .summary-reports { 
            display: grid; 
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); 
            gap: 20px; 
            margin-top: 20px; 
        }
        
        .report-card { 
            color: white; 
            padding: 25px; 
            border-radius: 10px; 
            box-shadow: 0 6px 15px rgba(0,0,0,0.15); 
            text-align: center; 
            display: flex; 
            flex-direction: column; 
            justify-content: space-between;
            transition: transform 0.3s, box-shadow 0.3s;
            min-height: 160px; /* উচ্চতা ঠিক রাখা */
        }
        .report-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
        }

        /* কার্ডের রঙ এবং আইকন */
        .report-card:nth-child(1) { background: linear-gradient(45deg, #3498db, #2980b9); } /* মোট শিক্ষার্থী */
        .report-card.today { background: linear-gradient(45deg, #2ecc71, #27ae60); } /* আজকের আয় */
        .report-card.expense-today { background: linear-gradient(45deg, #e74c3c, #c0392b); } /* আজকের ব্যয় */
        .report-card.month { background: linear-gradient(45deg, #f39c12, #e67e22); } /* মাসের আয় */
        .report-card.expense-month { background: linear-gradient(45deg, #9b59b6, #8e44ad); } /* মাসের ব্যয় */
        .report-card:nth-child(6) { background: linear-gradient(45deg, #34495e, #2c3e50); } /* নেট স্থিতি */

        .report-card h4 { margin: 0 0 10px; font-size: 1.3em; display: flex; align-items: center; justify-content: center; }
        .report-card p { margin: 0; font-size: 2.5em; font-weight: bold; }
        .report-card h4 i { margin-right: 10px; font-size: 1.2em; }
        
        .gender-breakdown { display: flex; justify-content: space-around; margin-top: 15px; padding-top: 15px; border-top: 1px solid rgba(255,255,255,0.3); }
        .gender-breakdown div { flex: 1; text-align: center; }
        .gender-breakdown small { font-size: 0.9em; opacity: 0.8; }
        .gender-breakdown p { font-size: 1.3em; font-weight: bold; margin: 0; }

        /* চার্ট বক্স স্টাইল */
        .chart-box {
            background-color: #ffffff;
            padding: 25px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            margin-top: 30px; 
            border: 1px solid #e0e0e0;
        }
        .chart-box h3 {
            text-align: center;
            color: #2c3e50;
        }
        
        /* ফুটার */
        .footer { text-align: center; padding: 15px; background-color: #2c3e50; color: #ecf0f1; position: relative; bottom: 0; width: 100%; margin-top: 20px;}

        /* রেসপনসিভনেস */
        @media (max-width: 992px) {
            .container {
                flex-direction: column;
                margin: 10px auto;
                padding: 10px;
            }
            .sidebar {
                width: 100%;
                padding: 10px;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            }
            .main-content {
                padding: 15px;
            }
            .summary-reports {
                grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            }
            .nav {
                justify-content: start;
            }
        }
        @media (max-width: 600px) {
             .summary-reports {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
<div class="header">
    <h1>মিফতাহুন নাজাত মহিলা মাদরাসা</h1>
    <p>নেয়ামতপুর সদর, নোয়াখালী</p>
    
    <div class="marquee-container">
        <marquee behavior="scroll" direction="left" scrollamount="6" class="marquee-text">
            📞 এ সফটওয়্যার ব্যবহারে আপনার কোনো সমস্যা হলে আমাকে কল করুন: 
            <span style="color: #c0392b; font-size: 1.2em; margin: 0 15px;">০১৮৭৪৮১২৮৪৯</span> 
            📞 এ সফটওয়্যার ব্যবহারে আপনার কোনো সমস্যা হলে আমাকে কল করুন: 
            <span style="color: #c0392b; font-size: 1.2em; margin: 0 15px;">০১৮৭৪৮১২৮৪৯</span>
        </marquee>
    </div>
    
    <div class="nav">
        <a href="/school_management/public/logout.php">লগআউট</a>
    </div>
</div>

<div class="container">
    <div class="sidebar">
        <h3 class="sidebar-title"><i class="fas fa-link"></i> গুরুত্বপূর্ণ লিংকসমূহ</h3>
        
        <?php if ($_SESSION['role'] == 'Admin' || $_SESSION['role'] == 'Teacher'): ?>
        <div class="menu-item">
            <button class="menu-btn" onclick="toggleSubMenu('students-menu')"><i class="fas fa-user-graduate me-2"></i> শিক্ষার্থী <i class="fas fa-chevron-down"></i></button>
            <div class="sub-menu" id="students-menu">
                <a href="/school_management/public/students/students_list.php">শিক্ষার্থী ব্যবস্থাপনা</a>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($_SESSION['role'] == 'Admin'): ?>
        <div class="menu-item">
            <button class="menu-btn" onclick="toggleSubMenu('fees-menu')"><i class="fas fa-money-bill-wave me-2"></i> ফি সংগ্রহ ও রিপোর্ট <i class="fas fa-chevron-down"></i></button>
            <div class="sub-menu" id="fees-menu">
                <a href="/school_management/public/fees/fee_collection.php">ফি সংগ্রহ</a>
                <a href="/school_management/public/fees/fee_report.php">ফি রিপোর্ট দেখুন</a>
                <a href="/school_management/public/fees/monthly_fee_summary.php">মাসিক ফি সারাংশ</a>
                <a href="/school_management/public/fees/residential_fee_summary.php">আবাসিক ফি রিপোর্ট</a>
            </div>
        </div>

        <div class="menu-item">
            <button class="menu-btn" onclick="toggleSubMenu('incomes-menu')"><i class="fas fa-plus-circle me-2"></i> অন্যান্য আয় <i class="fas fa-chevron-down"></i></button>
            <div class="sub-menu" id="incomes-menu">
                <a href="/school_management/public/incomes/add_income.php">আয় যোগ করুন</a>
                <a href="/school_management/public/incomes/income_list.php">আয়ের তালিকা দেখুন</a>
                <a href="/school_management/public/incomes/income_report.php" style="background-color: #617b96;">আয়ের রিপোর্ট 📊</a>
                <a href="/school_management/public/incomes/income_sources_list.php">আয়ের উৎস পরিচালনা ⚙️</a>
            </div>
        </div>
        
        <div class="menu-item">
            <button class="menu-btn" onclick="toggleSubMenu('expenses-menu')" style="background-color: #dc3545;"><i class="fas fa-minus-circle me-2"></i> ব্যয় ব্যবস্থাপনা <i class="fas fa-chevron-down"></i></button> 
            <div class="sub-menu" id="expenses-menu">
                <a href="/school_management/public/expenses/add_expense.php">নতুন ব্যয় যুক্ত করুন</a>
                <a href="/school_management/public/expenses/expense_report.php">ব্যয় রিপোর্ট দেখুন 📊</a>
                <a href="/school_management/public/expenses/expense_categories_list.php">ব্যয়ের খাত পরিচালনা</a>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($_SESSION['role'] == 'Admin' || $_SESSION['role'] == 'Teacher'): ?>
        <div class="menu-item">
            <button class="menu-btn" onclick="toggleSubMenu('exams-menu')"><i class="fas fa-file-alt me-2"></i> পরীক্ষা <i class="fas fa-chevron-down"></i></button>
            <div class="sub-menu" id="exams-menu">
                <a href="/school_management/public/exam_results/add_exam_result.php">পরীক্ষার ফলাফল যোগ করুন</a>
                <a href="/school_management/public/exam_results/exam_report.php">পরীক্ষার রিপোর্ট দেখুন</a>
                <a href="/school_management/public/exam_results/first_term_exam_report.php">প্রথম সাময়িক রিপোর্ট</a>
                <a href="/school_management/public/exam_results/second_term_exam_report.php">দ্বিতীয় সাময়িক রিপোর্ট</a>
                <a href="/school_management/public/exam_results/annual_exam_report.php">বার্ষিক রিপোর্ট</a>
                <a href="/school_management/public/students/admit_card_generator.php">প্রবেশ পত্র</a>
                <a href="/school_management/public/routines/routine_form.php">রুটিন তৈরি</a>
                <a href="/school_management/public/routines/routine_grid_report.php">রুটিন দেখন</a>
                <a href="/school_management/public/routines/view_routines.php">রুটিন তালিকা</a>
                <a href="/school_management/public/students/mark_sheet_search.php">মার্কশিট</a>
                <a href="/school_management/public/promote_students.php" style="background-color: #8e44ad; color: white;">শিক্ষার্থী প্রমোশন (পরবর্তী ক্লাস)</a>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($_SESSION['role'] == 'Admin'): ?>
        <div class="menu-item">
            <button class="menu-btn" onclick="toggleSubMenu('notices-menu')" style="background-color: #8e44ad;"><i class="fas fa-bullhorn me-2"></i> নোটিস ও সার্কুলার 🔔 <i class="fas fa-chevron-down"></i></button>
            <div class="sub-menu" id="notices-menu">
                <a href="/school_management/public/notices/notices_list.php">নোটিস ব্যবস্থাপনা</a>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($_SESSION['role'] == 'Admin'): ?>
        <div class="menu-item">
            <button class="menu-btn" onclick="toggleSubMenu('financial-reports-menu')" style="background-color: #2980b9;"><i class="fas fa-chart-bar me-2"></i> আর্থিক রিপোর্ট <i class="fas fa-chevron-down"></i></button>
            <div class="sub-menu" id="financial-reports-menu">
                <a href="/school_management/public/fees/fee_report.php">শিক্ষার্থী ফি রিপোর্ট</a>
                <a href="/school_management/public/expenses/expense_report.php">ব্যয় রিপোর্ট</a>
                <a href="/school_management/public/incomes/income_categories_list.php">আয়ের খাতসমূহ</a>
                <a href="/school_management/public/incomes/income_expense_summary.php">আয়-ব্যয় সারাংশ</a>
                <a href="/school_management/public/incomes/current_cash.php">বর্তমান ক্যাশ</a>
            </div>
        </div>
        <?php endif; ?>
        
        <?php if ($_SESSION['role'] == 'Admin' || $_SESSION['role'] == 'Teacher'): ?>
        <div class="menu-item">
            <button class="menu-btn" onclick="toggleSubMenu('teachers-menu')"><i class="fas fa-chalkboard-teacher me-2"></i> শিক্ষক <i class="fas fa-chevron-down"></i></button>
            <div class="sub-menu" id="teachers-menu">
                <a href="/school_management/public/teachers/teachers_list.php">শিক্ষক ব্যবস্থাপনা</a>
                <a href="/school_management/public/expenses/teacher_salary_report.php" style="background-color: #f39c12;">শিক্ষক বেতন রিপোর্ট 💵</a> 
            </div>
        </div>
        <?php endif; ?>

        <?php if ($_SESSION['role'] == 'Admin'): ?>
        <div class="menu-item">
            <button class="menu-btn" onclick="toggleSubMenu('classes-menu')"><i class="fas fa-school me-2"></i> শ্রেণি <i class="fas fa-chevron-down"></i></button>
            <div class="sub-menu" id="classes-menu">
                <a href="/school_management/public/classes/classes_list.php">শ্রেণি ব্যবস্থাপনা</a>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($_SESSION['role'] == 'Admin'): ?>
        <div class="menu-item">
            <button class="menu-btn" onclick="toggleSubMenu('subjects-menu')"><i class="fas fa-book me-2"></i> বিষয় <i class="fas fa-chevron-down"></i></button>
            <div class="sub-menu" id="subjects-menu">
                <a href="/school_management/public/subjects/subjects_list.php">বিষয় ব্যবস্থাপনা</a>
            </div>
        </div>
        <?php endif; ?>
        
        <div class="menu-item">
            <button class="menu-btn" onclick="toggleSubMenu('attendance-menu')"><i class="fas fa-clipboard-check me-2"></i> উপস্থিতি <i class="fas fa-chevron-down"></i></button>
            <div class="sub-menu" id="attendance-menu">
                <a href="/school_management/public/attendance/record_attendance.php">উপস্থিতি রেকর্ড</a>
                <a href="/school_management/public/attendance/attendance_report.php">উপস্থিতি রিপোর্ট দেখুন</a>
            </div>
        </div>

        <div class="menu-item">
            <button class="menu-btn" onclick="toggleSubMenu('profile-menu')"><i class="fas fa-user-cog me-2"></i> প্রোফাইল ও সেটিংস <i class="fas fa-chevron-down"></i></button>
            <div class="sub-menu" id="profile-menu">
                <a href="/school_management/public/change_password.php">পাসওয়ার্ড পরিবর্তন</a>
                <a href="/school_management/public/developer_info.html">ডেভেলপার পরিচিতি</a>
                 <a href="backup_db.php" class="backup-btn" title="সম্পূর্ণ ডাটাবেস ব্যাকআপ ডাউনলোড করুন">
                <i class="fas fa-database"></i> ডেটাবেস ব্যাকআপ
                <a href="/school_management/public/logout.php" style="background-color: #c0392b;">লগআউট 🚪</a>
            </div>
        </div>

    </div>

    <div class="main-content">
        <div class="content-box">
            <div class="datetime-display">
                <h3><?php echo $current_date_bangla; ?></h3>
                <p id="current-time"><?php echo $current_time; ?></p>
            </div>
            <div class="clear"></div>
            
            <h2 style="color: #3498db;"><i class="fas fa-tachometer-alt me-2"></i> ড্যাশবোর্ড</h2>
            <p>স্বাগতম, **<?php echo htmlspecialchars($_SESSION['username']); ?>**! আপনার ভূমিকা: **<?php echo htmlspecialchars($_SESSION['role']); ?>**</p>

            
            <h3><i class="fas fa-info-circle me-2"></i> দ্রুত সারাংশ রিপোর্ট</h3>
            <div class="summary-reports">
                <div class="report-card">
                    <h4><i class="fas fa-users"></i> মোট শিক্ষার্থী</h4>
                    <p><?php echo $total_students; ?></p>
                    <div class="gender-breakdown">
                        <div>
                            <small>ছেলে</small>
                            <p style="font-size: 1.3em;"><?php echo $total_male_students; ?></p>
                        </div>
                        <div>
                            <small>মেয়ে</small>
                            <p style="font-size: 1.3em;"><?php echo $total_female_students; ?></p>
                        </div>
                    </div>
                </div>
                
                <div class="report-card today">
                    <h4><i class="fas fa-money-check-alt"></i> আজকের মোট আয়</h4>
                    <p>৳<?php echo number_format($today_total_collection, 2); ?></p>
                    <div class="gender-breakdown" style="border-top: none;">
                        <div>
                            <small>ফি</small>
                            <p style="font-size: 1.2em;">৳<?php echo number_format($today_fee_collection, 2); ?></p>
                        </div>
                        <div>
                            <small>অন্যান্য</small>
                            <p style="font-size: 1.2em;">৳<?php echo number_format($today_other_income, 2); ?></p>
                        </div>
                    </div>
                </div>
                
                <div class="report-card expense-today">
                    <h4><i class="fas fa-receipt"></i> আজকের মোট ব্যয়</h4>
                    <p>৳<?php echo number_format($today_total_expense, 2); ?></p>
                    <div class="gender-breakdown" style="border-top: none;">
                        <div style="flex-grow: 1;">
                            <a href="/school_management/public/expenses/expense_report.php" style="color: white; text-decoration: underline;"><small>ব্যয় রিপোর্ট দেখতে ক্লিক করুন</small></a>
                            <p style="font-size: 1.2em;">🔴 সতর্কতা</p>
                        </div>
                    </div>
                </div>
                
                <div class="report-card month">
                    <h4><i class="fas fa-calendar-alt"></i> এই মাসের মোট আয়</h4>
                    <p>৳<?php echo number_format($this_month_total_collection, 2); ?></p>
                    <div class="gender-breakdown" style="border-top: none;">
                        <div>
                            <small>ফি</small>
                            <p style="font-size: 1.2em;">৳<?php echo number_format($this_month_fee_collection, 2); ?></p>
                        </div>
                        <div>
                            <small>অন্যান্য</small>
                            <p style="font-size: 1.2em;">৳<?php echo number_format($this_month_other_income, 2); ?></p>
                        </div>
                    </div>
                </div>

                <div class="report-card expense-month">
                    <h4><i class="fas fa-hand-holding-usd"></i> এই মাসের মোট ব্যয়</h4>
                    <p>৳<?php echo number_format($this_month_total_expense, 2); ?></p>
                    <div class="gender-breakdown" style="border-top: none;">
                        <div style="flex-grow: 1;">
                            <a href="/school_management/public/expenses/expense_report.php" style="color: white; text-decoration: underline;"><small>ব্যয় রিপোর্ট দেখতে ক্লিক করুন</small></a>
                            <p style="font-size: 1.2em;">🟣 বিশ্লেষণ</p>
                        </div>
                    </div>
                </div>
                
                <div class="report-card" style="background-color: #34495e;">
                    <h4><i class="fas fa-balance-scale"></i> নেট স্থিতি (মাসিক)</h4>
                    <p>৳<?php echo number_format($this_month_total_collection - $this_month_total_expense, 2); ?></p>
                    <div class="gender-breakdown" style="border-top: none;">
                        <div style="flex-grow: 1;">
                            <small>আয় - ব্যয় = নেট ক্যাশ ফ্লো</small>
                            <p style="font-size: 1.2em;">📊 আর্থিক অবস্থা</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="chart-box">
                <h3 style="color: #2c3e50;">📈 গত ৬ মাসের মাসিক আয়ের তুলনামূলক চার্ট</h3>
                <canvas id="monthlyIncomeChart" style="max-height: 400px;"></canvas>
            </div>
            </div>
    </div>
</div>

<div class="footer">
    <p>&copy; <?php echo date("Y"); ?> School Management System. All Rights Reserved. | <span style="color: #f1c40f;">Developed by Arman</span></p>
</div>

<script>
    function toggleSubMenu(id) {
        var subMenu = document.getElementById(id);
        var allSubMenus = document.querySelectorAll('.sub-menu');
        
        if (subMenu.style.display === "block") {
            subMenu.style.display = "none";
        } else {
            // সমস্ত সাব-মেনু বন্ধ করুন, শুধুমাত্র বর্তমানেরটি বাদে
            allSubMenus.forEach(function(menu) {
                if (menu.id !== id) {
                    menu.style.display = 'none';
                }
            });
            subMenu.style.display = "block";
        }
    }

    // Live Clock functionality
    function updateClock() {
        const now = new Date();
        // এটি Asia/Dhaka টাইমজোন অনুযায়ী কাজ নাও করতে পারে যদি PHP টাইমজোন ঠিক না থাকে।
        // তবে বর্তমানের জন্য এটি ঠিক রাখা হলো।
        
        let hours = now.getHours();
        const ampm = hours >= 12 ? 'PM' : 'AM';
        hours = hours % 12;
        hours = hours ? hours : 12; // The hour '0' should be '12'
        const minutes = now.getMinutes().toString().padStart(2, '0');
        const seconds = now.getSeconds().toString().padStart(2, '0');
        
        const timeString = `${hours}:${minutes}:${seconds} ${ampm}`;
        
        document.getElementById('current-time').innerText = timeString;
    }

    // Update the clock every second
    setInterval(updateClock, 1000);

    // ===============================================
    // Chart.js ইনিশিয়ালাইজেশন এবং কনফিগারেশন
    // ===============================================

    // PHP থেকে JSON ডাটা গ্রহণ করা
    const chartLabels = <?php echo $chart_labels; ?>;
    const chartData = <?php echo $chart_data; ?>;

    const ctx = document.getElementById('monthlyIncomeChart').getContext('2d');
    const monthlyIncomeChart = new Chart(ctx, {
        type: 'bar', // বার চার্ট ব্যবহার করা হলো
        data: {
            labels: chartLabels,
            datasets: [{
                label: 'মোট মাসিক আয় (৳)',
                data: chartData,
                backgroundColor: 'rgba(52, 152, 219, 0.8)', // বার চার্টের রং
                borderColor: 'rgba(41, 128, 185, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false, 
            scales: {
                y: {
                    beginAtZero: true,
                    title: {
                        display: true,
                        text: 'আয় (টাকা)',
                        font: {
                            family: 'Tiro Bangla, Arial, sans-serif'
                        }
                    }
                },
                x: {
                    title: {
                        display: true,
                        text: 'মাস',
                        font: {
                            family: 'Tiro Bangla, Arial, sans-serif'
                        }
                    }
                }
            },
            plugins: {
                legend: {
                    display: true,
                    position: 'top',
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            let label = context.dataset.label || '';
                            if (label) {
                                label += ': ';
                            }
                            if (context.parsed.y !== null) {
                                label += '৳' + context.parsed.y.toLocaleString('en-IN', { minimumFractionDigits: 2 });
                            }
                            return label;
                        }
                    }
                }
            }
        }
    });

</script>

</body>
</html>