<?php
session_start();
include '../../includes/db_connection.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: /school_management/public/index.php");
    exit();
}

$message = isset($_GET['message']) ? htmlspecialchars($_GET['message']) : '';
$error = isset($_GET['error']) ? htmlspecialchars($_GET['error']) : '';

// Handle delete action
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $class_id = $_GET['id'];
    $sql_delete = "DELETE FROM classes WHERE class_id = ?";
    $stmt = $conn->prepare($sql_delete);
    $stmt->bind_param("i", $class_id);

    if ($stmt->execute()) {
        header("Location: classes_list.php?message=" . urlencode("Class deleted successfully!"));
        exit();
    } else {
        header("Location: classes_list.php?error=" . urlencode("Error deleting class."));
        exit();
    }
    $stmt->close();
}

// Fetch all classes
$sql_classes = "SELECT class_id, class_name FROM classes ORDER BY class_name";
$result_classes = $conn->query($sql_classes);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Class List</title>
    <link rel="stylesheet" href="/school_management/public/css/style.css">
    <style>
        .class-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .class-table th, .class-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .class-table th {
            background-color: #f2f2f2;
        }
        .action-links a {
            margin-right: 10px;
            text-decoration: none;
            color: #3498db;
        }
        .action-links a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
<div class="header">
    <h1>School Management System</h1>
    <div class="nav">
        <a href="/school_management/public/dashboard.php">Dashboard</a>
        <a href="/school_management/public/students/students_list.php">Students</a>
        <a href="/school_management/public/teachers/teachers_list.php">Teachers</a>
        <a href="/school_management/public/fees/fee_collection.php">Fees</a>
        <a href="/school_management/public/subjects/subjects_list.php">Subjects</a>
        <a href="/school_management/public/classes/classes_list.php">Classes</a>
        <a href="/school_management/public/exam_results/add_exam_result.php">Exams</a>
        <a href="/school_management/public/attendance/record_attendance.php">Attendance</a>
        <a href="/school_management/public/change_password.php">Change Password</a>
        <a href="/school_management/public/logout.php">Logout</a>
    </div>
</div>

<div class="content">
    <div class="container">
        <h2>Class List</h2>
        <?php if ($message): ?>
            <p style='color:green;'><?php echo $message; ?></p>
        <?php endif; ?>
        <?php if ($error): ?>
            <p style='color:red;'><?php echo $error; ?></p>
        <?php endif; ?>
        <a href="add_class.php" class="button">Add New Class</a>
        <br><br>
        <table class="class-table">
            <thead>
                <tr>
                    <th>Class ID</th>
                    <th>Class Name</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result_classes->num_rows > 0) {
                    while($row = $result_classes->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($row['class_id']) . "</td>";
                        echo "<td>" . htmlspecialchars($row['class_name']) . "</td>";
                        echo "<td class='action-links'>";
                        echo "<a href='classes_list.php?action=delete&id=" . htmlspecialchars($row['class_id']) . "' onclick='return confirm(\"Are you sure you want to delete this class?\");'>Delete</a>";
                        echo "</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='3'>No classes found.</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
    <div class="footer">
        <p>&copy; <?php echo date("Y"); ?> School Management System. All Rights Reserved.</p>
    </div>
</div>
</body>
</html>