<?php
include '../includes/db_connection.php';

// 'আবাসিক ফি' ক্যাটাগরির আইডি খুঁজে বের করা
$residential_fee_name = 'আবাসিক ফি';
$stmt_category = $conn->prepare("SELECT category_id FROM income_categories WHERE category_name = ?");
$stmt_category->bind_param("s", $residential_fee_name);
$stmt_category->execute();
$stmt_category->bind_result($residential_fee_id);
$stmt_category->fetch();
$stmt_category->close();

echo "<h1>ডাটাবেস যাচাইকরণ</h1>";
echo "<p>আপনার ডাটাবেসে '{$residential_fee_name}' এর আইডি হলো: <strong>" . htmlspecialchars($residential_fee_id) . "</strong></p>";

// 'আবাসিক' ক্লাসের আইডি খুঁজে বের করা
$residential_class_name = 'আবাসিক';
$stmt_class = $conn->prepare("SELECT class_id FROM classes WHERE class_name = ?");
$stmt_class->bind_param("s", $residential_class_name);
$stmt_class->execute();
$stmt_class->bind_result($residential_class_id);
$stmt_class->fetch();
$stmt_class->close();

echo "<p>আপনার ডাটাবেসে '{$residential_class_name}' ক্লাসের আইডি হলো: <strong>" . htmlspecialchars($residential_class_id) . "</strong></p>";
?>